package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters._
final case class WorkspaceSettings(
    s3ArtifactPath: Optional[S3Uri] = Optional.Absent,
    s3KmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.WorkspaceSettings = {
    import WorkspaceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.WorkspaceSettings
      .builder()
      .optionallyWith(
        s3ArtifactPath.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3ArtifactPath)
      .optionallyWith(
        s3KmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.s3KmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.WorkspaceSettings.ReadOnly =
    zio.aws.sagemaker.model.WorkspaceSettings.wrap(buildAwsValue())
}
object WorkspaceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.WorkspaceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.WorkspaceSettings =
      zio.aws.sagemaker.model.WorkspaceSettings(
        s3ArtifactPath.map(value => value),
        s3KmsKeyId.map(value => value)
      )
    def s3ArtifactPath: Optional[S3Uri]
    def s3KmsKeyId: Optional[KmsKeyId]
    def getS3ArtifactPath: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3ArtifactPath", s3ArtifactPath)
    def getS3KmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("s3KmsKeyId", s3KmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.WorkspaceSettings
  ) extends zio.aws.sagemaker.model.WorkspaceSettings.ReadOnly {
    override val s3ArtifactPath: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ArtifactPath())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val s3KmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.WorkspaceSettings
  ): zio.aws.sagemaker.model.WorkspaceSettings.ReadOnly = new Wrapper(impl)
}
