package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.TtlDurationValue
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TtlDuration(
    unit: Optional[zio.aws.sagemaker.model.TtlDurationUnit] = Optional.Absent,
    value: Optional[TtlDurationValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TtlDuration = {
    import TtlDuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TtlDuration
      .builder()
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        value.map(value => TtlDurationValue.unwrap(value): Integer)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TtlDuration.ReadOnly =
    zio.aws.sagemaker.model.TtlDuration.wrap(buildAwsValue())
}
object TtlDuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TtlDuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TtlDuration =
      zio.aws.sagemaker.model
        .TtlDuration(unit.map(value => value), value.map(value => value))
    def unit: Optional[zio.aws.sagemaker.model.TtlDurationUnit]
    def value: Optional[TtlDurationValue]
    def getUnit: ZIO[Any, AwsError, zio.aws.sagemaker.model.TtlDurationUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, TtlDurationValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TtlDuration
  ) extends zio.aws.sagemaker.model.TtlDuration.ReadOnly {
    override val unit: Optional[zio.aws.sagemaker.model.TtlDurationUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.sagemaker.model.TtlDurationUnit.wrap(value))
    override val value: Optional[TtlDurationValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.sagemaker.model.primitives.TtlDurationValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TtlDuration
  ): zio.aws.sagemaker.model.TtlDuration.ReadOnly = new Wrapper(impl)
}
