package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetTrackingScalingPolicyConfiguration(
    metricSpecification: Optional[zio.aws.sagemaker.model.MetricSpecification] =
      Optional.Absent,
    targetValue: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TargetTrackingScalingPolicyConfiguration = {
    import TargetTrackingScalingPolicyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TargetTrackingScalingPolicyConfiguration
      .builder()
      .optionallyWith(metricSpecification.map(value => value.buildAwsValue()))(
        _.metricSpecification
      )
      .optionallyWith(targetValue.map(value => value: java.lang.Double))(
        _.targetValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration
      .wrap(buildAwsValue())
}
object TargetTrackingScalingPolicyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TargetTrackingScalingPolicyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration =
      zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration(
        metricSpecification.map(value => value.asEditable),
        targetValue.map(value => value)
      )
    def metricSpecification
        : Optional[zio.aws.sagemaker.model.MetricSpecification.ReadOnly]
    def targetValue: Optional[Double]
    def getMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("metricSpecification", metricSpecification)
    def getTargetValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("targetValue", targetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TargetTrackingScalingPolicyConfiguration
  ) extends zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration.ReadOnly {
    override val metricSpecification
        : Optional[zio.aws.sagemaker.model.MetricSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricSpecification())
        .map(value => zio.aws.sagemaker.model.MetricSpecification.wrap(value))
    override val targetValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.targetValue())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TargetTrackingScalingPolicyConfiguration
  ): zio.aws.sagemaker.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    new Wrapper(impl)
}
