package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SpaceSettings(
    jupyterServerAppSettings: Optional[
      zio.aws.sagemaker.model.JupyterServerAppSettings
    ] = Optional.Absent,
    kernelGatewayAppSettings: Optional[
      zio.aws.sagemaker.model.KernelGatewayAppSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SpaceSettings = {
    import SpaceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SpaceSettings
      .builder()
      .optionallyWith(
        jupyterServerAppSettings.map(value => value.buildAwsValue())
      )(_.jupyterServerAppSettings)
      .optionallyWith(
        kernelGatewayAppSettings.map(value => value.buildAwsValue())
      )(_.kernelGatewayAppSettings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SpaceSettings.ReadOnly =
    zio.aws.sagemaker.model.SpaceSettings.wrap(buildAwsValue())
}
object SpaceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SpaceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SpaceSettings =
      zio.aws.sagemaker.model.SpaceSettings(
        jupyterServerAppSettings.map(value => value.asEditable),
        kernelGatewayAppSettings.map(value => value.asEditable)
      )
    def jupyterServerAppSettings
        : Optional[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly]
    def kernelGatewayAppSettings
        : Optional[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly]
    def getJupyterServerAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jupyterServerAppSettings",
      jupyterServerAppSettings
    )
    def getKernelGatewayAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayAppSettings",
      kernelGatewayAppSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SpaceSettings
  ) extends zio.aws.sagemaker.model.SpaceSettings.ReadOnly {
    override val jupyterServerAppSettings
        : Optional[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jupyterServerAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.JupyterServerAppSettings.wrap(value)
        )
    override val kernelGatewayAppSettings
        : Optional[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelGatewayAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayAppSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SpaceSettings
  ): zio.aws.sagemaker.model.SpaceSettings.ReadOnly = new Wrapper(impl)
}
