package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SourceAlgorithmSpecification(
    sourceAlgorithms: Iterable[zio.aws.sagemaker.model.SourceAlgorithm]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification = {
    import SourceAlgorithmSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification
      .builder()
      .sourceAlgorithms(sourceAlgorithms.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly =
    zio.aws.sagemaker.model.SourceAlgorithmSpecification.wrap(buildAwsValue())
}
object SourceAlgorithmSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SourceAlgorithmSpecification =
      zio.aws.sagemaker.model
        .SourceAlgorithmSpecification(sourceAlgorithms.map { item =>
          item.asEditable
        })
    def sourceAlgorithms: List[zio.aws.sagemaker.model.SourceAlgorithm.ReadOnly]
    def getSourceAlgorithms: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.SourceAlgorithm.ReadOnly
    ]] = ZIO.succeed(sourceAlgorithms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification
  ) extends zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly {
    override val sourceAlgorithms
        : List[zio.aws.sagemaker.model.SourceAlgorithm.ReadOnly] = impl
      .sourceAlgorithms()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.SourceAlgorithm.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification
  ): zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly =
    new Wrapper(impl)
}
