package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{Percentage, ModelVariantName}
import scala.jdk.CollectionConverters._
final case class ShadowModelVariantConfig(
    shadowModelVariantName: ModelVariantName,
    samplingPercentage: Percentage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig = {
    import ShadowModelVariantConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig
      .builder()
      .shadowModelVariantName(
        ModelVariantName.unwrap(shadowModelVariantName): java.lang.String
      )
      .samplingPercentage(Percentage.unwrap(samplingPercentage): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ShadowModelVariantConfig.ReadOnly =
    zio.aws.sagemaker.model.ShadowModelVariantConfig.wrap(buildAwsValue())
}
object ShadowModelVariantConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ShadowModelVariantConfig =
      zio.aws.sagemaker.model
        .ShadowModelVariantConfig(shadowModelVariantName, samplingPercentage)
    def shadowModelVariantName: ModelVariantName
    def samplingPercentage: Percentage
    def getShadowModelVariantName: ZIO[Any, Nothing, ModelVariantName] =
      ZIO.succeed(shadowModelVariantName)
    def getSamplingPercentage: ZIO[Any, Nothing, Percentage] =
      ZIO.succeed(samplingPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig
  ) extends zio.aws.sagemaker.model.ShadowModelVariantConfig.ReadOnly {
    override val shadowModelVariantName: ModelVariantName =
      zio.aws.sagemaker.model.primitives
        .ModelVariantName(impl.shadowModelVariantName())
    override val samplingPercentage: Percentage =
      zio.aws.sagemaker.model.primitives.Percentage(impl.samplingPercentage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig
  ): zio.aws.sagemaker.model.ShadowModelVariantConfig.ReadOnly = new Wrapper(
    impl
  )
}
