package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class SelectiveExecutionConfig(
    sourcePipelineExecutionArn: PipelineExecutionArn,
    selectedSteps: Iterable[zio.aws.sagemaker.model.SelectedStep]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig = {
    import SelectiveExecutionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
      .builder()
      .sourcePipelineExecutionArn(
        PipelineExecutionArn.unwrap(
          sourcePipelineExecutionArn
        ): java.lang.String
      )
      .selectedSteps(selectedSteps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly =
    zio.aws.sagemaker.model.SelectiveExecutionConfig.wrap(buildAwsValue())
}
object SelectiveExecutionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SelectiveExecutionConfig =
      zio.aws.sagemaker.model.SelectiveExecutionConfig(
        sourcePipelineExecutionArn,
        selectedSteps.map { item =>
          item.asEditable
        }
      )
    def sourcePipelineExecutionArn: PipelineExecutionArn
    def selectedSteps: List[zio.aws.sagemaker.model.SelectedStep.ReadOnly]
    def getSourcePipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(sourcePipelineExecutionArn)
    def getSelectedSteps: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.SelectedStep.ReadOnly
    ]] = ZIO.succeed(selectedSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
  ) extends zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly {
    override val sourcePipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.sourcePipelineExecutionArn())
    override val selectedSteps
        : List[zio.aws.sagemaker.model.SelectedStep.ReadOnly] = impl
      .selectedSteps()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.SelectedStep.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
  ): zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly = new Wrapper(
    impl
  )
}
