package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ResourceCatalogSortOrder {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder
}
object ResourceCatalogSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder
  ): zio.aws.sagemaker.model.ResourceCatalogSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ResourceCatalogSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending
      extends zio.aws.sagemaker.model.ResourceCatalogSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder.ASCENDING
  }
  case object Descending
      extends zio.aws.sagemaker.model.ResourceCatalogSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortOrder.DESCENDING
  }
}
