package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{HumanTaskUiArn, RoleArn}
import scala.jdk.CollectionConverters._
final case class RenderUiTemplateRequest(
    uiTemplate: Optional[zio.aws.sagemaker.model.UiTemplate] = Optional.Absent,
    task: zio.aws.sagemaker.model.RenderableTask,
    roleArn: RoleArn,
    humanTaskUiArn: Optional[HumanTaskUiArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest = {
    import RenderUiTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest
      .builder()
      .optionallyWith(uiTemplate.map(value => value.buildAwsValue()))(
        _.uiTemplate
      )
      .task(task.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        humanTaskUiArn.map(value =>
          HumanTaskUiArn.unwrap(value): java.lang.String
        )
      )(_.humanTaskUiArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RenderUiTemplateRequest.ReadOnly =
    zio.aws.sagemaker.model.RenderUiTemplateRequest.wrap(buildAwsValue())
}
object RenderUiTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RenderUiTemplateRequest =
      zio.aws.sagemaker.model.RenderUiTemplateRequest(
        uiTemplate.map(value => value.asEditable),
        task.asEditable,
        roleArn,
        humanTaskUiArn.map(value => value)
      )
    def uiTemplate: Optional[zio.aws.sagemaker.model.UiTemplate.ReadOnly]
    def task: zio.aws.sagemaker.model.RenderableTask.ReadOnly
    def roleArn: RoleArn
    def humanTaskUiArn: Optional[HumanTaskUiArn]
    def getUiTemplate
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UiTemplate.ReadOnly] =
      AwsError.unwrapOptionField("uiTemplate", uiTemplate)
    def getTask
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RenderableTask.ReadOnly] =
      ZIO.succeed(task)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getHumanTaskUiArn: ZIO[Any, AwsError, HumanTaskUiArn] =
      AwsError.unwrapOptionField("humanTaskUiArn", humanTaskUiArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest
  ) extends zio.aws.sagemaker.model.RenderUiTemplateRequest.ReadOnly {
    override val uiTemplate
        : Optional[zio.aws.sagemaker.model.UiTemplate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uiTemplate())
        .map(value => zio.aws.sagemaker.model.UiTemplate.wrap(value))
    override val task: zio.aws.sagemaker.model.RenderableTask.ReadOnly =
      zio.aws.sagemaker.model.RenderableTask.wrap(impl.task())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val humanTaskUiArn: Optional[HumanTaskUiArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanTaskUiArn())
        .map(value => zio.aws.sagemaker.model.primitives.HumanTaskUiArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest
  ): zio.aws.sagemaker.model.RenderUiTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
