package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ServerlessProvisionedConcurrency,
  ServerlessMaxConcurrency
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProductionVariantServerlessUpdateConfig(
    maxConcurrency: Optional[ServerlessMaxConcurrency] = Optional.Absent,
    provisionedConcurrency: Optional[ServerlessProvisionedConcurrency] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessUpdateConfig = {
    import ProductionVariantServerlessUpdateConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessUpdateConfig
      .builder()
      .optionallyWith(
        maxConcurrency.map(value =>
          ServerlessMaxConcurrency.unwrap(value): Integer
        )
      )(_.maxConcurrency)
      .optionallyWith(
        provisionedConcurrency.map(value =>
          ServerlessProvisionedConcurrency.unwrap(value): Integer
        )
      )(_.provisionedConcurrency)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ProductionVariantServerlessUpdateConfig.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariantServerlessUpdateConfig
      .wrap(buildAwsValue())
}
object ProductionVariantServerlessUpdateConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessUpdateConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ProductionVariantServerlessUpdateConfig =
      zio.aws.sagemaker.model.ProductionVariantServerlessUpdateConfig(
        maxConcurrency.map(value => value),
        provisionedConcurrency.map(value => value)
      )
    def maxConcurrency: Optional[ServerlessMaxConcurrency]
    def provisionedConcurrency: Optional[ServerlessProvisionedConcurrency]
    def getMaxConcurrency: ZIO[Any, AwsError, ServerlessMaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getProvisionedConcurrency
        : ZIO[Any, AwsError, ServerlessProvisionedConcurrency] = AwsError
      .unwrapOptionField("provisionedConcurrency", provisionedConcurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessUpdateConfig
  ) extends zio.aws.sagemaker.model.ProductionVariantServerlessUpdateConfig.ReadOnly {
    override val maxConcurrency: Optional[ServerlessMaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ServerlessMaxConcurrency(value)
        )
    override val provisionedConcurrency
        : Optional[ServerlessProvisionedConcurrency] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedConcurrency())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .ServerlessProvisionedConcurrency(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessUpdateConfig
  ): zio.aws.sagemaker.model.ProductionVariantServerlessUpdateConfig.ReadOnly =
    new Wrapper(impl)
}
