package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ProcessingS3DataType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType
}
object ProcessingS3DataType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType
  ): zio.aws.sagemaker.model.ProcessingS3DataType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType.MANIFEST_FILE =>
      val r = ManifestFile
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType.S3_PREFIX =>
      val r = S3Prefix
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProcessingS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType.UNKNOWN_TO_SDK_VERSION
  }
  case object ManifestFile
      extends zio.aws.sagemaker.model.ProcessingS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType.MANIFEST_FILE
  }
  case object S3Prefix extends zio.aws.sagemaker.model.ProcessingS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType.S3_PREFIX
  }
}
