package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PredefinedMetricSpecification(
    predefinedMetricType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PredefinedMetricSpecification = {
    import PredefinedMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PredefinedMetricSpecification
      .builder()
      .optionallyWith(
        predefinedMetricType.map(value => value: java.lang.String)
      )(_.predefinedMetricType)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.PredefinedMetricSpecification.ReadOnly =
    zio.aws.sagemaker.model.PredefinedMetricSpecification.wrap(buildAwsValue())
}
object PredefinedMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PredefinedMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PredefinedMetricSpecification =
      zio.aws.sagemaker.model
        .PredefinedMetricSpecification(predefinedMetricType.map(value => value))
    def predefinedMetricType: Optional[String]
    def getPredefinedMetricType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("predefinedMetricType", predefinedMetricType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PredefinedMetricSpecification
  ) extends zio.aws.sagemaker.model.PredefinedMetricSpecification.ReadOnly {
    override val predefinedMetricType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.predefinedMetricType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PredefinedMetricSpecification
  ): zio.aws.sagemaker.model.PredefinedMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
