package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{String1024, PipelineParameterName}
import scala.jdk.CollectionConverters._
final case class Parameter(name: PipelineParameterName, value: String1024) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Parameter
      .builder()
      .name(PipelineParameterName.unwrap(name): java.lang.String)
      .value(String1024.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Parameter.ReadOnly =
    zio.aws.sagemaker.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Parameter =
      zio.aws.sagemaker.model.Parameter(name, value)
    def name: PipelineParameterName
    def value: String1024
    def getName: ZIO[Any, Nothing, PipelineParameterName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String1024] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Parameter
  ) extends zio.aws.sagemaker.model.Parameter.ReadOnly {
    override val name: PipelineParameterName =
      zio.aws.sagemaker.model.primitives.PipelineParameterName(impl.name())
    override val value: String1024 =
      zio.aws.sagemaker.model.primitives.String1024(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Parameter
  ): zio.aws.sagemaker.model.Parameter.ReadOnly = new Wrapper(impl)
}
