package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait Operator {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.Operator
}
object Operator {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.Operator
  ): zio.aws.sagemaker.model.Operator = value match {
    case software.amazon.awssdk.services.sagemaker.model.Operator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.EQUALS =>
      val r = Equals
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.NOT_EQUALS =>
      val r = NotEquals
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.GREATER_THAN_OR_EQUAL_TO =>
      val r = GreaterThanOrEqualTo
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.LESS_THAN_OR_EQUAL_TO =>
      val r = LessThanOrEqualTo
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.CONTAINS =>
      val r = Contains
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.EXISTS =>
      val r = Exists
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.NOT_EXISTS =>
      val r = NotExists
      r
    case software.amazon.awssdk.services.sagemaker.model.Operator.IN =>
      val r = In
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.UNKNOWN_TO_SDK_VERSION
  }
  case object Equals extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.EQUALS
  }
  case object NotEquals extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.NOT_EQUALS
  }
  case object GreaterThan extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.GREATER_THAN
  }
  case object GreaterThanOrEqualTo extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.GREATER_THAN_OR_EQUAL_TO
  }
  case object LessThan extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.LESS_THAN
  }
  case object LessThanOrEqualTo extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.LESS_THAN_OR_EQUAL_TO
  }
  case object Contains extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.CONTAINS
  }
  case object Exists extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.EXISTS
  }
  case object NotExists extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.NOT_EXISTS
  }
  case object In extends zio.aws.sagemaker.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Operator =
      software.amazon.awssdk.services.sagemaker.model.Operator.IN
  }
}
