package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonitoringJsonDatasetFormat(
    line: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringJsonDatasetFormat = {
    import MonitoringJsonDatasetFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringJsonDatasetFormat
      .builder()
      .optionallyWith(line.map(value => value: java.lang.Boolean))(_.line)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.ReadOnly =
    zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.wrap(buildAwsValue())
}
object MonitoringJsonDatasetFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringJsonDatasetFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringJsonDatasetFormat =
      zio.aws.sagemaker.model
        .MonitoringJsonDatasetFormat(line.map(value => value))
    def line: Optional[Boolean]
    def getLine: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("line", line)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringJsonDatasetFormat
  ) extends zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.ReadOnly {
    override val line: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.line())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringJsonDatasetFormat
  ): zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.ReadOnly = new Wrapper(
    impl
  )
}
