package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters._
final case class ModelRegisterSettings(
    status: Optional[zio.aws.sagemaker.model.FeatureStatus] = Optional.Absent,
    crossAccountModelRegisterRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings = {
    import ModelRegisterSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        crossAccountModelRegisterRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.crossAccountModelRegisterRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelRegisterSettings.ReadOnly =
    zio.aws.sagemaker.model.ModelRegisterSettings.wrap(buildAwsValue())
}
object ModelRegisterSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelRegisterSettings =
      zio.aws.sagemaker.model.ModelRegisterSettings(
        status.map(value => value),
        crossAccountModelRegisterRoleArn.map(value => value)
      )
    def status: Optional[zio.aws.sagemaker.model.FeatureStatus]
    def crossAccountModelRegisterRoleArn: Optional[RoleArn]
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCrossAccountModelRegisterRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField(
        "crossAccountModelRegisterRoleArn",
        crossAccountModelRegisterRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings
  ) extends zio.aws.sagemaker.model.ModelRegisterSettings.ReadOnly {
    override val status: Optional[zio.aws.sagemaker.model.FeatureStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.FeatureStatus.wrap(value))
    override val crossAccountModelRegisterRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountModelRegisterRoleArn())
        .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings
  ): zio.aws.sagemaker.model.ModelRegisterSettings.ReadOnly = new Wrapper(impl)
}
