package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelDashboardIndicatorAction(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDashboardIndicatorAction = {
    import ModelDashboardIndicatorAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardIndicatorAction
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelDashboardIndicatorAction.ReadOnly =
    zio.aws.sagemaker.model.ModelDashboardIndicatorAction.wrap(buildAwsValue())
}
object ModelDashboardIndicatorAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardIndicatorAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDashboardIndicatorAction =
      zio.aws.sagemaker.model
        .ModelDashboardIndicatorAction(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardIndicatorAction
  ) extends zio.aws.sagemaker.model.ModelDashboardIndicatorAction.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardIndicatorAction
  ): zio.aws.sagemaker.model.ModelDashboardIndicatorAction.ReadOnly =
    new Wrapper(impl)
}
