package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelCompressionType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelCompressionType
}
object ModelCompressionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCompressionType
  ): zio.aws.sagemaker.model.ModelCompressionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCompressionType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCompressionType.GZIP =>
      val r = Gzip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCompressionType =
      software.amazon.awssdk.services.sagemaker.model.ModelCompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.sagemaker.model.ModelCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCompressionType =
      software.amazon.awssdk.services.sagemaker.model.ModelCompressionType.NONE
  }
  case object Gzip extends zio.aws.sagemaker.model.ModelCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCompressionType =
      software.amazon.awssdk.services.sagemaker.model.ModelCompressionType.GZIP
  }
}
