package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ModelCardArn,
  Integer,
  EntityName,
  ModelCardContent
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelCard(
    modelCardArn: Optional[ModelCardArn] = Optional.Absent,
    modelCardName: Optional[EntityName] = Optional.Absent,
    modelCardVersion: Optional[Integer] = Optional.Absent,
    content: Optional[ModelCardContent] = Optional.Absent,
    modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      Optional.Absent,
    securityConfig: Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    modelId: Optional[String] = Optional.Absent,
    riskRating: Optional[String] = Optional.Absent,
    modelPackageGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelCard = {
    import ModelCard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelCard
      .builder()
      .optionallyWith(
        modelCardArn.map(value => ModelCardArn.unwrap(value): java.lang.String)
      )(_.modelCardArn)
      .optionallyWith(
        modelCardName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelCardName)
      .optionallyWith(modelCardVersion.map(value => value: java.lang.Integer))(
        _.modelCardVersion
      )
      .optionallyWith(
        content.map(value => ModelCardContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(modelCardStatus.map(value => value.unwrap))(
        _.modelCardStatus
      )
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(modelId.map(value => value: java.lang.String))(_.modelId)
      .optionallyWith(riskRating.map(value => value: java.lang.String))(
        _.riskRating
      )
      .optionallyWith(
        modelPackageGroupName.map(value => value: java.lang.String)
      )(_.modelPackageGroupName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelCard.ReadOnly =
    zio.aws.sagemaker.model.ModelCard.wrap(buildAwsValue())
}
object ModelCard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelCard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelCard =
      zio.aws.sagemaker.model.ModelCard(
        modelCardArn.map(value => value),
        modelCardName.map(value => value),
        modelCardVersion.map(value => value),
        content.map(value => value),
        modelCardStatus.map(value => value),
        securityConfig.map(value => value.asEditable),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelId.map(value => value),
        riskRating.map(value => value),
        modelPackageGroupName.map(value => value)
      )
    def modelCardArn: Optional[ModelCardArn]
    def modelCardName: Optional[EntityName]
    def modelCardVersion: Optional[Integer]
    def content: Optional[ModelCardContent]
    def modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus]
    def securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def modelId: Optional[String]
    def riskRating: Optional[String]
    def modelPackageGroupName: Optional[String]
    def getModelCardArn: ZIO[Any, AwsError, ModelCardArn] =
      AwsError.unwrapOptionField("modelCardArn", modelCardArn)
    def getModelCardName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelCardName", modelCardName)
    def getModelCardVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("modelCardVersion", modelCardVersion)
    def getContent: ZIO[Any, AwsError, ModelCardContent] =
      AwsError.unwrapOptionField("content", content)
    def getModelCardStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardStatus] =
      AwsError.unwrapOptionField("modelCardStatus", modelCardStatus)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getModelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelId", modelId)
    def getRiskRating: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("riskRating", riskRating)
    def getModelPackageGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCard
  ) extends zio.aws.sagemaker.model.ModelCard.ReadOnly {
    override val modelCardArn: Optional[ModelCardArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelCardArn(value))
    override val modelCardName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelCardVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardVersion())
      .map(value => value: Integer)
    override val content: Optional[ModelCardContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.sagemaker.model.primitives.ModelCardContent(value))
    override val modelCardStatus
        : Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCardStatus())
        .map(value => zio.aws.sagemaker.model.ModelCardStatus.wrap(value))
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardSecurityConfig.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val modelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelId())
      .map(value => value: String)
    override val riskRating: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.riskRating())
      .map(value => value: String)
    override val modelPackageGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPackageGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCard
  ): zio.aws.sagemaker.model.ModelCard.ReadOnly = new Wrapper(impl)
}
