package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  MaxResults,
  Timestamp,
  ResourceCatalogName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResourceCatalogsRequest(
    nameContains: Optional[ResourceCatalogName] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.ResourceCatalogSortOrder] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.ResourceCatalogSortBy] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest = {
    import ListResourceCatalogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest
      .builder()
      .optionallyWith(
        nameContains.map(value =>
          ResourceCatalogName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListResourceCatalogsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListResourceCatalogsRequest.wrap(buildAwsValue())
}
object ListResourceCatalogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListResourceCatalogsRequest =
      zio.aws.sagemaker.model.ListResourceCatalogsRequest(
        nameContains.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def nameContains: Optional[ResourceCatalogName]
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def sortOrder: Optional[zio.aws.sagemaker.model.ResourceCatalogSortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.ResourceCatalogSortBy]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getNameContains: ZIO[Any, AwsError, ResourceCatalogName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceCatalogSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceCatalogSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest
  ) extends zio.aws.sagemaker.model.ListResourceCatalogsRequest.ReadOnly {
    override val nameContains: Optional[ResourceCatalogName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ResourceCatalogName(value)
        )
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortOrder
        : Optional[zio.aws.sagemaker.model.ResourceCatalogSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value =>
          zio.aws.sagemaker.model.ResourceCatalogSortOrder.wrap(value)
        )
    override val sortBy
        : Optional[zio.aws.sagemaker.model.ResourceCatalogSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.ResourceCatalogSortBy.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest
  ): zio.aws.sagemaker.model.ListResourceCatalogsRequest.ReadOnly = new Wrapper(
    impl
  )
}
