package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  LabelingJobArn,
  WorkteamArn,
  Timestamp,
  FailureReason,
  LabelingJobName,
  LambdaFunctionArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LabelingJobSummary(
    labelingJobName: LabelingJobName,
    labelingJobArn: LabelingJobArn,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    labelingJobStatus: zio.aws.sagemaker.model.LabelingJobStatus,
    labelCounters: zio.aws.sagemaker.model.LabelCounters,
    workteamArn: WorkteamArn,
    preHumanTaskLambdaArn: LambdaFunctionArn,
    annotationConsolidationLambdaArn: Optional[LambdaFunctionArn] =
      Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    labelingJobOutput: Optional[zio.aws.sagemaker.model.LabelingJobOutput] =
      Optional.Absent,
    inputConfig: Optional[zio.aws.sagemaker.model.LabelingJobInputConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary = {
    import LabelingJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary
      .builder()
      .labelingJobName(
        LabelingJobName.unwrap(labelingJobName): java.lang.String
      )
      .labelingJobArn(LabelingJobArn.unwrap(labelingJobArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .labelingJobStatus(labelingJobStatus.unwrap)
      .labelCounters(labelCounters.buildAwsValue())
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .preHumanTaskLambdaArn(
        LambdaFunctionArn.unwrap(preHumanTaskLambdaArn): java.lang.String
      )
      .optionallyWith(
        annotationConsolidationLambdaArn.map(value =>
          LambdaFunctionArn.unwrap(value): java.lang.String
        )
      )(_.annotationConsolidationLambdaArn)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(labelingJobOutput.map(value => value.buildAwsValue()))(
        _.labelingJobOutput
      )
      .optionallyWith(inputConfig.map(value => value.buildAwsValue()))(
        _.inputConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobSummary.wrap(buildAwsValue())
}
object LabelingJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobSummary =
      zio.aws.sagemaker.model.LabelingJobSummary(
        labelingJobName,
        labelingJobArn,
        creationTime,
        lastModifiedTime,
        labelingJobStatus,
        labelCounters.asEditable,
        workteamArn,
        preHumanTaskLambdaArn,
        annotationConsolidationLambdaArn.map(value => value),
        failureReason.map(value => value),
        labelingJobOutput.map(value => value.asEditable),
        inputConfig.map(value => value.asEditable)
      )
    def labelingJobName: LabelingJobName
    def labelingJobArn: LabelingJobArn
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def labelingJobStatus: zio.aws.sagemaker.model.LabelingJobStatus
    def labelCounters: zio.aws.sagemaker.model.LabelCounters.ReadOnly
    def workteamArn: WorkteamArn
    def preHumanTaskLambdaArn: LambdaFunctionArn
    def annotationConsolidationLambdaArn: Optional[LambdaFunctionArn]
    def failureReason: Optional[FailureReason]
    def labelingJobOutput
        : Optional[zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly]
    def inputConfig
        : Optional[zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly]
    def getLabelingJobName: ZIO[Any, Nothing, LabelingJobName] =
      ZIO.succeed(labelingJobName)
    def getLabelingJobArn: ZIO[Any, Nothing, LabelingJobArn] =
      ZIO.succeed(labelingJobArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getLabelingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.LabelingJobStatus] =
      ZIO.succeed(labelingJobStatus)
    def getLabelCounters
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.LabelCounters.ReadOnly] =
      ZIO.succeed(labelCounters)
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getPreHumanTaskLambdaArn: ZIO[Any, Nothing, LambdaFunctionArn] =
      ZIO.succeed(preHumanTaskLambdaArn)
    def getAnnotationConsolidationLambdaArn
        : ZIO[Any, AwsError, LambdaFunctionArn] = AwsError.unwrapOptionField(
      "annotationConsolidationLambdaArn",
      annotationConsolidationLambdaArn
    )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getLabelingJobOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("labelingJobOutput", labelingJobOutput)
    def getInputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputConfig", inputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary
  ) extends zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly {
    override val labelingJobName: LabelingJobName =
      zio.aws.sagemaker.model.primitives.LabelingJobName(impl.labelingJobName())
    override val labelingJobArn: LabelingJobArn =
      zio.aws.sagemaker.model.primitives.LabelingJobArn(impl.labelingJobArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val labelingJobStatus: zio.aws.sagemaker.model.LabelingJobStatus =
      zio.aws.sagemaker.model.LabelingJobStatus.wrap(impl.labelingJobStatus())
    override val labelCounters: zio.aws.sagemaker.model.LabelCounters.ReadOnly =
      zio.aws.sagemaker.model.LabelCounters.wrap(impl.labelCounters())
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val preHumanTaskLambdaArn: LambdaFunctionArn =
      zio.aws.sagemaker.model.primitives
        .LambdaFunctionArn(impl.preHumanTaskLambdaArn())
    override val annotationConsolidationLambdaArn: Optional[LambdaFunctionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.annotationConsolidationLambdaArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LambdaFunctionArn(value)
        )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val labelingJobOutput
        : Optional[zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelingJobOutput())
        .map(value => zio.aws.sagemaker.model.LabelingJobOutput.wrap(value))
    override val inputConfig
        : Optional[zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputConfig())
        .map(value =>
          zio.aws.sagemaker.model.LabelingJobInputConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary
  ): zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly = new Wrapper(impl)
}
