package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait InferenceExperimentStopDesiredState {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState
}
object InferenceExperimentStopDesiredState {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState
  ): zio.aws.sagemaker.model.InferenceExperimentStopDesiredState = value match {
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState.CANCELLED =>
      val r = Cancelled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.InferenceExperimentStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState.UNKNOWN_TO_SDK_VERSION
  }
  case object Completed
      extends zio.aws.sagemaker.model.InferenceExperimentStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState.COMPLETED
  }
  case object Cancelled
      extends zio.aws.sagemaker.model.InferenceExperimentStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStopDesiredState.CANCELLED
  }
}
