package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageClassificationJobConfig(
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig = {
    import ImageClassificationJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig
      .builder()
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ImageClassificationJobConfig.ReadOnly =
    zio.aws.sagemaker.model.ImageClassificationJobConfig.wrap(buildAwsValue())
}
object ImageClassificationJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ImageClassificationJobConfig =
      zio.aws.sagemaker.model.ImageClassificationJobConfig(
        completionCriteria.map(value => value.asEditable)
      )
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig
  ) extends zio.aws.sagemaker.model.ImageClassificationJobConfig.ReadOnly {
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig
  ): zio.aws.sagemaker.model.ImageClassificationJobConfig.ReadOnly =
    new Wrapper(impl)
}
