package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait FlatInvocations {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.FlatInvocations
}
object FlatInvocations {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FlatInvocations
  ): zio.aws.sagemaker.model.FlatInvocations = value match {
    case software.amazon.awssdk.services.sagemaker.model.FlatInvocations.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FlatInvocations.CONTINUE =>
      val r = Continue
      r
    case software.amazon.awssdk.services.sagemaker.model.FlatInvocations.STOP =>
      val r = Stop
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FlatInvocations {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlatInvocations =
      software.amazon.awssdk.services.sagemaker.model.FlatInvocations.UNKNOWN_TO_SDK_VERSION
  }
  case object Continue extends zio.aws.sagemaker.model.FlatInvocations {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlatInvocations =
      software.amazon.awssdk.services.sagemaker.model.FlatInvocations.CONTINUE
  }
  case object Stop extends zio.aws.sagemaker.model.FlatInvocations {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlatInvocations =
      software.amazon.awssdk.services.sagemaker.model.FlatInvocations.STOP
  }
}
