package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  FeatureParameterValue,
  FeatureParameterKey
}
import scala.jdk.CollectionConverters._
final case class FeatureParameter(
    key: Optional[FeatureParameterKey] = Optional.Absent,
    value: Optional[FeatureParameterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureParameter = {
    import FeatureParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureParameter
      .builder()
      .optionallyWith(
        key.map(value => FeatureParameterKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value =>
          FeatureParameterValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureParameter.ReadOnly =
    zio.aws.sagemaker.model.FeatureParameter.wrap(buildAwsValue())
}
object FeatureParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureParameter =
      zio.aws.sagemaker.model
        .FeatureParameter(key.map(value => value), value.map(value => value))
    def key: Optional[FeatureParameterKey]
    def value: Optional[FeatureParameterValue]
    def getKey: ZIO[Any, AwsError, FeatureParameterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, FeatureParameterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureParameter
  ) extends zio.aws.sagemaker.model.FeatureParameter.ReadOnly {
    override val key: Optional[FeatureParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.sagemaker.model.primitives.FeatureParameterKey(value)
      )
    override val value: Optional[FeatureParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.sagemaker.model.primitives.FeatureParameterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureParameter
  ): zio.aws.sagemaker.model.FeatureParameter.ReadOnly = new Wrapper(impl)
}
