package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait EndpointStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.EndpointStatus
}
object EndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.EndpointStatus
  ): zio.aws.sagemaker.model.EndpointStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.OUT_OF_SERVICE =>
      val r = OutOfService
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.SYSTEM_UPDATING =>
      val r = SystemUpdating
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.ROLLING_BACK =>
      val r = RollingBack
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointStatus.UPDATE_ROLLBACK_FAILED =>
      val r = UpdateRollbackFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OutOfService extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.OUT_OF_SERVICE
  }
  case object Creating extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.CREATING
  }
  case object Updating extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.UPDATING
  }
  case object SystemUpdating extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.SYSTEM_UPDATING
  }
  case object RollingBack extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.ROLLING_BACK
  }
  case object InService extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.IN_SERVICE
  }
  case object Deleting extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.DELETING
  }
  case object Failed extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.FAILED
  }
  case object UpdateRollbackFailed
      extends zio.aws.sagemaker.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointStatus =
      software.amazon.awssdk.services.sagemaker.model.EndpointStatus.UPDATE_ROLLBACK_FAILED
  }
}
