package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.InitialInstanceCount
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EndpointOutputConfiguration(
    endpointName: String,
    variantName: String,
    instanceType: Optional[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = Optional.Absent,
    initialInstanceCount: Optional[InitialInstanceCount] = Optional.Absent,
    serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration = {
    import EndpointOutputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
      .builder()
      .endpointName(endpointName: java.lang.String)
      .variantName(variantName: java.lang.String)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        initialInstanceCount.map(value =>
          InitialInstanceCount.unwrap(value): Integer
        )
      )(_.initialInstanceCount)
      .optionallyWith(serverlessConfig.map(value => value.buildAwsValue()))(
        _.serverlessConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly =
    zio.aws.sagemaker.model.EndpointOutputConfiguration.wrap(buildAwsValue())
}
object EndpointOutputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointOutputConfiguration =
      zio.aws.sagemaker.model.EndpointOutputConfiguration(
        endpointName,
        variantName,
        instanceType.map(value => value),
        initialInstanceCount.map(value => value),
        serverlessConfig.map(value => value.asEditable)
      )
    def endpointName: String
    def variantName: String
    def instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    def initialInstanceCount: Optional[InitialInstanceCount]
    def serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
    def getVariantName: ZIO[Any, Nothing, String] = ZIO.succeed(variantName)
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInitialInstanceCount: ZIO[Any, AwsError, InitialInstanceCount] =
      AwsError.unwrapOptionField("initialInstanceCount", initialInstanceCount)
    def getServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("serverlessConfig", serverlessConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
  ) extends zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
    override val variantName: String = impl.variantName(): String
    override val instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(value)
        )
    override val initialInstanceCount: Optional[InitialInstanceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialInstanceCount())
        .map(value =>
          zio.aws.sagemaker.model.primitives.InitialInstanceCount(value)
        )
    override val serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
  ): zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
