package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentDescription,
  ExperimentArn,
  ExperimentEntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeExperimentResponse(
    experimentName: Optional[ExperimentEntityName] = Optional.Absent,
    experimentArn: Optional[ExperimentArn] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ExperimentSource] =
      Optional.Absent,
    description: Optional[ExperimentDescription] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse = {
    import DescribeExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse
      .builder()
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(
        experimentArn.map(value =>
          ExperimentArn.unwrap(value): java.lang.String
        )
      )(_.experimentArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeExperimentResponse.wrap(buildAwsValue())
}
object DescribeExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeExperimentResponse =
      zio.aws.sagemaker.model.DescribeExperimentResponse(
        experimentName.map(value => value),
        experimentArn.map(value => value),
        displayName.map(value => value),
        source.map(value => value.asEditable),
        description.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def experimentName: Optional[ExperimentEntityName]
    def experimentArn: Optional[ExperimentArn]
    def displayName: Optional[ExperimentEntityName]
    def source: Optional[zio.aws.sagemaker.model.ExperimentSource.ReadOnly]
    def description: Optional[ExperimentDescription]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getExperimentArn: ZIO[Any, AwsError, ExperimentArn] =
      AwsError.unwrapOptionField("experimentArn", experimentArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentSource.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse
  ) extends zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly {
    override val experimentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val experimentArn: Optional[ExperimentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.experimentArn())
      .map(value => zio.aws.sagemaker.model.primitives.ExperimentArn(value))
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.ExperimentSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ExperimentSource.wrap(value))
    override val description: Optional[ExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse
  ): zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
