package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  KmsKeyId,
  EndpointConfigArn,
  EndpointConfigName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeEndpointConfigResponse(
    endpointConfigName: EndpointConfigName,
    endpointConfigArn: EndpointConfigArn,
    productionVariants: Iterable[zio.aws.sagemaker.model.ProductionVariant],
    dataCaptureConfig: Optional[zio.aws.sagemaker.model.DataCaptureConfig] =
      Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    creationTime: Timestamp,
    asyncInferenceConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceConfig
    ] = Optional.Absent,
    explainerConfig: Optional[zio.aws.sagemaker.model.ExplainerConfig] =
      Optional.Absent,
    shadowProductionVariants: Optional[
      Iterable[zio.aws.sagemaker.model.ProductionVariant]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse = {
    import DescribeEndpointConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .endpointConfigArn(
        EndpointConfigArn.unwrap(endpointConfigArn): java.lang.String
      )
      .productionVariants(productionVariants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(asyncInferenceConfig.map(value => value.buildAwsValue()))(
        _.asyncInferenceConfig
      )
      .optionallyWith(explainerConfig.map(value => value.buildAwsValue()))(
        _.explainerConfig
      )
      .optionallyWith(
        shadowProductionVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shadowProductionVariants)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeEndpointConfigResponse.wrap(buildAwsValue())
}
object DescribeEndpointConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEndpointConfigResponse =
      zio.aws.sagemaker.model.DescribeEndpointConfigResponse(
        endpointConfigName,
        endpointConfigArn,
        productionVariants.map { item =>
          item.asEditable
        },
        dataCaptureConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value),
        creationTime,
        asyncInferenceConfig.map(value => value.asEditable),
        explainerConfig.map(value => value.asEditable),
        shadowProductionVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def endpointConfigName: EndpointConfigName
    def endpointConfigArn: EndpointConfigArn
    def productionVariants
        : List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly]
    def dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly]
    def kmsKeyId: Optional[KmsKeyId]
    def creationTime: Timestamp
    def asyncInferenceConfig
        : Optional[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly]
    def explainerConfig
        : Optional[zio.aws.sagemaker.model.ExplainerConfig.ReadOnly]
    def shadowProductionVariants
        : Optional[List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly]]
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getEndpointConfigArn: ZIO[Any, Nothing, EndpointConfigArn] =
      ZIO.succeed(endpointConfigArn)
    def getProductionVariants: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ProductionVariant.ReadOnly
    ]] = ZIO.succeed(productionVariants)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getAsyncInferenceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("asyncInferenceConfig", asyncInferenceConfig)
    def getExplainerConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ExplainerConfig.ReadOnly] =
      AwsError.unwrapOptionField("explainerConfig", explainerConfig)
    def getShadowProductionVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariant.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "shadowProductionVariants",
      shadowProductionVariants
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val endpointConfigArn: EndpointConfigArn =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigArn(impl.endpointConfigArn())
    override val productionVariants
        : List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly] = impl
      .productionVariants()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ProductionVariant.wrap(item)
      }
      .toList
    override val dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCaptureConfig())
        .map(value => zio.aws.sagemaker.model.DataCaptureConfig.wrap(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val asyncInferenceConfig
        : Optional[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.asyncInferenceConfig())
        .map(value => zio.aws.sagemaker.model.AsyncInferenceConfig.wrap(value))
    override val explainerConfig
        : Optional[zio.aws.sagemaker.model.ExplainerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainerConfig())
        .map(value => zio.aws.sagemaker.model.ExplainerConfig.wrap(value))
    override val shadowProductionVariants
        : Optional[List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shadowProductionVariants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ProductionVariant.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
  ): zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly =
    new Wrapper(impl)
}
