package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ClarifyShapSeed,
  ClarifyShapUseLogit,
  ClarifyShapNumberOfSamples
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ClarifyShapConfig(
    shapBaselineConfig: zio.aws.sagemaker.model.ClarifyShapBaselineConfig,
    numberOfSamples: Optional[ClarifyShapNumberOfSamples] = Optional.Absent,
    useLogit: Optional[ClarifyShapUseLogit] = Optional.Absent,
    seed: Optional[ClarifyShapSeed] = Optional.Absent,
    textConfig: Optional[zio.aws.sagemaker.model.ClarifyTextConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ClarifyShapConfig = {
    import ClarifyShapConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ClarifyShapConfig
      .builder()
      .shapBaselineConfig(shapBaselineConfig.buildAwsValue())
      .optionallyWith(
        numberOfSamples.map(value =>
          ClarifyShapNumberOfSamples.unwrap(value): Integer
        )
      )(_.numberOfSamples)
      .optionallyWith(
        useLogit.map(value =>
          ClarifyShapUseLogit.unwrap(value): java.lang.Boolean
        )
      )(_.useLogit)
      .optionallyWith(
        seed.map(value => ClarifyShapSeed.unwrap(value): Integer)
      )(_.seed)
      .optionallyWith(textConfig.map(value => value.buildAwsValue()))(
        _.textConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ClarifyShapConfig.ReadOnly =
    zio.aws.sagemaker.model.ClarifyShapConfig.wrap(buildAwsValue())
}
object ClarifyShapConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ClarifyShapConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ClarifyShapConfig =
      zio.aws.sagemaker.model.ClarifyShapConfig(
        shapBaselineConfig.asEditable,
        numberOfSamples.map(value => value),
        useLogit.map(value => value),
        seed.map(value => value),
        textConfig.map(value => value.asEditable)
      )
    def shapBaselineConfig
        : zio.aws.sagemaker.model.ClarifyShapBaselineConfig.ReadOnly
    def numberOfSamples: Optional[ClarifyShapNumberOfSamples]
    def useLogit: Optional[ClarifyShapUseLogit]
    def seed: Optional[ClarifyShapSeed]
    def textConfig: Optional[zio.aws.sagemaker.model.ClarifyTextConfig.ReadOnly]
    def getShapBaselineConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ClarifyShapBaselineConfig.ReadOnly
    ] = ZIO.succeed(shapBaselineConfig)
    def getNumberOfSamples: ZIO[Any, AwsError, ClarifyShapNumberOfSamples] =
      AwsError.unwrapOptionField("numberOfSamples", numberOfSamples)
    def getUseLogit: ZIO[Any, AwsError, ClarifyShapUseLogit] =
      AwsError.unwrapOptionField("useLogit", useLogit)
    def getSeed: ZIO[Any, AwsError, ClarifyShapSeed] =
      AwsError.unwrapOptionField("seed", seed)
    def getTextConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ClarifyTextConfig.ReadOnly
    ] = AwsError.unwrapOptionField("textConfig", textConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyShapConfig
  ) extends zio.aws.sagemaker.model.ClarifyShapConfig.ReadOnly {
    override val shapBaselineConfig
        : zio.aws.sagemaker.model.ClarifyShapBaselineConfig.ReadOnly =
      zio.aws.sagemaker.model.ClarifyShapBaselineConfig
        .wrap(impl.shapBaselineConfig())
    override val numberOfSamples: Optional[ClarifyShapNumberOfSamples] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfSamples())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyShapNumberOfSamples(value)
        )
    override val useLogit: Optional[ClarifyShapUseLogit] = zio.aws.core.internal
      .optionalFromNullable(impl.useLogit())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ClarifyShapUseLogit(value)
      )
    override val seed: Optional[ClarifyShapSeed] = zio.aws.core.internal
      .optionalFromNullable(impl.seed())
      .map(value => zio.aws.sagemaker.model.primitives.ClarifyShapSeed(value))
    override val textConfig
        : Optional[zio.aws.sagemaker.model.ClarifyTextConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textConfig())
        .map(value => zio.aws.sagemaker.model.ClarifyTextConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyShapConfig
  ): zio.aws.sagemaker.model.ClarifyShapConfig.ReadOnly = new Wrapper(impl)
}
