package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AggregationTransformationValue {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue
}
object AggregationTransformationValue {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue
  ): zio.aws.sagemaker.model.AggregationTransformationValue = value match {
    case software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.SUM =>
      val r = sum
      r
    case software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.AVG =>
      val r = avg
      r
    case software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.FIRST =>
      val r = first
      r
    case software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.MIN =>
      val r = min
      r
    case software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.MAX =>
      val r = max
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AggregationTransformationValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue =
      software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.UNKNOWN_TO_SDK_VERSION
  }
  case object sum
      extends zio.aws.sagemaker.model.AggregationTransformationValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue =
      software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.SUM
  }
  case object avg
      extends zio.aws.sagemaker.model.AggregationTransformationValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue =
      software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.AVG
  }
  case object first
      extends zio.aws.sagemaker.model.AggregationTransformationValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue =
      software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.FIRST
  }
  case object min
      extends zio.aws.sagemaker.model.AggregationTransformationValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue =
      software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.MIN
  }
  case object max
      extends zio.aws.sagemaker.model.AggregationTransformationValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue =
      software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue.MAX
  }
}
