package zio.aws.sagemaker
import zio.aws.sagemaker.model.DescribePipelineExecutionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias
import zio.aws.sagemaker.model.{
  DescribeEdgePackagingJobRequest,
  CreateAppRequest,
  ListInferenceRecommendationsJobsRequest,
  DescribeAlgorithmRequest,
  CreateEndpointRequest,
  DeleteDataQualityJobDefinitionRequest,
  DescribeNotebookInstanceLifecycleConfigRequest,
  DescribeProcessingJobRequest,
  StartNotebookInstanceRequest,
  DescribeModelCardExportJobRequest,
  UpdateTrialRequest,
  CreateFeatureGroupRequest,
  DeleteContextRequest,
  UpdateMonitoringScheduleRequest,
  DescribeHumanTaskUiRequest,
  ListAutoMlJobsRequest,
  ListTrainingJobsRequest,
  UpdateImageRequest,
  DeleteStudioLifecycleConfigRequest,
  UpdateMonitoringAlertRequest,
  UpdateSpaceRequest,
  ListUserProfilesRequest,
  DeleteHumanTaskUiRequest,
  DescribeAppRequest,
  ListMonitoringExecutionsRequest,
  ListTrainingJobsForHyperParameterTuningJobRequest,
  CreateTrialComponentRequest,
  ListHyperParameterTuningJobsRequest,
  ListDeviceFleetsRequest,
  ListNotebookInstancesRequest,
  StopInferenceExperimentRequest,
  ListInferenceRecommendationsJobStepsRequest,
  DeleteEndpointRequest,
  DescribePipelineExecutionRequest,
  UpdateNotebookInstanceRequest,
  UpdateInferenceExperimentRequest,
  DeleteInferenceExperimentRequest,
  UpdateDeviceFleetRequest,
  DescribeMonitoringScheduleRequest,
  ListPipelineExecutionStepsRequest,
  DescribeFeatureGroupRequest,
  DeleteNotebookInstanceRequest,
  GetDeviceFleetReportRequest,
  ListTrialComponentsRequest,
  StopAutoMlJobRequest,
  DeleteTrialRequest,
  UpdateWorkforceRequest,
  ListTrialsRequest,
  DescribeDeviceRequest,
  ListCompilationJobsRequest,
  DeleteModelCardRequest,
  ListModelBiasJobDefinitionsRequest,
  DisassociateTrialComponentRequest,
  DescribeTrialRequest,
  ListImageVersionsRequest,
  DescribeModelPackageGroupRequest,
  CreateProjectRequest,
  DescribeImageVersionRequest,
  StopNotebookInstanceRequest,
  ListEndpointsRequest,
  CreateHumanTaskUiRequest,
  DeleteTagsRequest,
  DeleteFlowDefinitionRequest,
  DescribeWorkforceRequest,
  CreateNotebookInstanceRequest,
  CreateModelExplainabilityJobDefinitionRequest,
  RetryPipelineExecutionRequest,
  DeleteCodeRepositoryRequest,
  ListTagsRequest,
  DescribeModelCardRequest,
  StopTrainingJobRequest,
  StartMonitoringScheduleRequest,
  UpdateArtifactRequest,
  UpdateFeatureMetadataRequest,
  CreateEdgeDeploymentStageRequest,
  DeleteAppImageConfigRequest,
  UpdateDomainRequest,
  ListNotebookInstanceLifecycleConfigsRequest,
  GetScalingConfigurationRecommendationRequest,
  CreateModelCardRequest,
  StopLabelingJobRequest,
  CreateEdgePackagingJobRequest,
  ListMonitoringAlertsRequest,
  ListPipelineExecutionsRequest,
  GetSagemakerServicecatalogPortfolioStatusRequest,
  UpdateDevicesRequest,
  CreateEdgeDeploymentPlanRequest,
  ListEdgePackagingJobsRequest,
  StopPipelineExecutionRequest,
  RenderUiTemplateRequest,
  DeleteHubContentRequest,
  StartEdgeDeploymentStageRequest,
  CreateNotebookInstanceLifecycleConfigRequest,
  UpdateAppImageConfigRequest,
  ListTransformJobsRequest,
  ListStudioLifecycleConfigsRequest,
  ListLabelingJobsRequest,
  UpdateExperimentRequest,
  SendPipelineExecutionStepFailureRequest,
  StopEdgeDeploymentStageRequest,
  ListHubContentVersionsRequest,
  DescribeLabelingJobRequest,
  UpdateEndpointRequest,
  DescribePipelineDefinitionForExecutionRequest,
  ListAppImageConfigsRequest,
  CreateModelPackageGroupRequest,
  ListHumanTaskUisRequest,
  GetModelPackageGroupPolicyRequest,
  ListWorkteamsRequest,
  UpdateCodeRepositoryRequest,
  DescribeModelExplainabilityJobDefinitionRequest,
  CreateModelQualityJobDefinitionRequest,
  CreateLabelingJobRequest,
  ListFlowDefinitionsRequest,
  DescribeModelRequest,
  DisableSagemakerServicecatalogPortfolioRequest,
  ListResourceCatalogsRequest,
  ListHubContentsRequest,
  CreateTrialRequest,
  DescribeAppImageConfigRequest,
  ImportHubContentRequest,
  CreateWorkteamRequest,
  DeleteModelExplainabilityJobDefinitionRequest,
  DeleteImageRequest,
  ListAliasesRequest,
  CreateHubRequest,
  CreateModelRequest,
  DescribeNotebookInstanceRequest,
  CreatePresignedNotebookInstanceUrlRequest,
  ListEndpointConfigsRequest,
  UpdateImageVersionRequest,
  DescribeModelBiasJobDefinitionRequest,
  UpdatePipelineExecutionRequest,
  DescribeAutoMlJobRequest,
  UpdateEndpointWeightsAndCapacitiesRequest,
  CreateWorkforceRequest,
  DescribeInferenceExperimentRequest,
  StopTransformJobRequest,
  DescribeModelPackageRequest,
  ListPipelinesRequest,
  DescribeEdgeDeploymentPlanRequest,
  CreateStudioLifecycleConfigRequest,
  ListModelCardExportJobsRequest,
  StopProcessingJobRequest,
  DescribeWorkteamRequest,
  DeleteFeatureGroupRequest,
  GetLineageGroupPolicyRequest,
  DescribePipelineRequest,
  ListProcessingJobsRequest,
  UpdateProjectRequest,
  StopMonitoringScheduleRequest,
  AssociateTrialComponentRequest,
  CreatePresignedDomainUrlRequest,
  ListCodeRepositoriesRequest,
  AddTagsRequest,
  DescribeExperimentRequest,
  DescribeSpaceRequest,
  SearchRequest,
  StopInferenceRecommendationsJobRequest,
  DeleteModelBiasJobDefinitionRequest,
  UpdateFeatureGroupRequest,
  DescribeArtifactRequest,
  ListPipelineParametersForExecutionRequest,
  ListModelMetadataRequest,
  DeleteProjectRequest,
  ListModelsRequest,
  DescribeHyperParameterTuningJobRequest,
  DescribeDeviceFleetRequest,
  ListHubsRequest,
  CreateInferenceExperimentRequest,
  UpdateHubRequest,
  ListArtifactsRequest,
  DeleteDomainRequest,
  CreateDataQualityJobDefinitionRequest,
  ListInferenceExperimentsRequest,
  ListStageDevicesRequest,
  ListSubscribedWorkteamsRequest,
  ListDataQualityJobDefinitionsRequest,
  PutModelPackageGroupPolicyRequest,
  DescribeLineageGroupRequest,
  DeleteEdgeDeploymentPlanRequest,
  CreateAutoMlJobRequest,
  DeleteAssociationRequest,
  CreateFlowDefinitionRequest,
  ListMonitoringSchedulesRequest,
  UpdateModelCardRequest,
  CreateTrainingJobRequest,
  CreateAutoMlJobV2Request,
  CreateCodeRepositoryRequest,
  DescribeAutoMlJobV2Request,
  ListSpacesRequest,
  UpdateTrialComponentRequest,
  ListCandidatesForAutoMlJobRequest,
  ListWorkforcesRequest,
  DescribeDomainRequest,
  DeletePipelineRequest,
  ListModelCardVersionsRequest,
  DescribeModelQualityJobDefinitionRequest,
  DeleteModelPackageGroupRequest,
  ListModelCardsRequest,
  DescribeSubscribedWorkteamRequest,
  QueryLineageRequest,
  UpdateNotebookInstanceLifecycleConfigRequest,
  DescribeCodeRepositoryRequest,
  DeleteModelPackageGroupPolicyRequest,
  DescribeFeatureMetadataRequest,
  DeleteImageVersionRequest,
  CreateDomainRequest,
  CreateExperimentRequest,
  DescribeImageRequest,
  DeleteEndpointConfigRequest,
  ListLabelingJobsForWorkteamRequest,
  DescribeHubRequest,
  ListProjectsRequest,
  ListModelPackageGroupsRequest,
  ListModelPackagesRequest,
  DeleteUserProfileRequest,
  DeleteModelPackageRequest,
  StartInferenceExperimentRequest,
  CreateProcessingJobRequest,
  DeleteExperimentRequest,
  CreateActionRequest,
  DescribeTrialComponentRequest,
  DeleteModelQualityJobDefinitionRequest,
  DescribeContextRequest,
  DescribeInferenceRecommendationsJobRequest,
  DeleteHubRequest,
  CreateAlgorithmRequest,
  DeleteEdgeDeploymentStageRequest,
  AddAssociationRequest,
  DescribeEndpointRequest,
  DeleteTrialComponentRequest,
  CreateSpaceRequest,
  DescribeHubContentRequest,
  CreateImageRequest,
  StopCompilationJobRequest,
  UpdateModelPackageRequest,
  ListLineageGroupsRequest,
  DescribeTransformJobRequest,
  ListAlgorithmsRequest,
  ListModelExplainabilityJobDefinitionsRequest,
  DeleteAlgorithmRequest,
  ListAssociationsRequest,
  DescribeTrainingJobRequest,
  ListAppsRequest,
  CreateImageVersionRequest,
  DeleteWorkforceRequest,
  ListContextsRequest,
  CreateModelBiasJobDefinitionRequest,
  ListMonitoringAlertHistoryRequest,
  BatchDescribeModelPackageRequest,
  CreatePipelineRequest,
  DescribeUserProfileRequest,
  ListDevicesRequest,
  DeleteNotebookInstanceLifecycleConfigRequest,
  CreateMonitoringScheduleRequest,
  UpdateWorkteamRequest,
  ListActionsRequest,
  CreateContextRequest,
  CreateArtifactRequest,
  DescribeActionRequest,
  DescribeCompilationJobRequest,
  CreateTransformJobRequest,
  DeleteModelRequest,
  DeleteWorkteamRequest,
  DeleteArtifactRequest,
  ListExperimentsRequest,
  DeleteSpaceRequest,
  DeleteDeviceFleetRequest,
  StopHyperParameterTuningJobRequest,
  CreateModelCardExportJobRequest,
  CreateEndpointConfigRequest,
  DescribeEndpointConfigRequest,
  DeleteAppRequest,
  SendPipelineExecutionStepSuccessRequest,
  UpdatePipelineRequest,
  DeleteMonitoringScheduleRequest,
  ListEdgeDeploymentPlansRequest,
  DescribeDataQualityJobDefinitionRequest,
  DeregisterDevicesRequest,
  CreateDeviceFleetRequest,
  CreateCompilationJobRequest,
  DescribeFlowDefinitionRequest,
  EnableSagemakerServicecatalogPortfolioRequest,
  DescribeProjectRequest,
  ListFeatureGroupsRequest,
  StopEdgePackagingJobRequest,
  DescribeStudioLifecycleConfigRequest,
  CreateAppImageConfigRequest,
  UpdateTrainingJobRequest,
  ListDomainsRequest,
  CreateUserProfileRequest,
  UpdateUserProfileRequest,
  ListImagesRequest,
  GetSearchSuggestionsRequest,
  StartPipelineExecutionRequest,
  DeleteActionRequest,
  CreateInferenceRecommendationsJobRequest,
  UpdateContextRequest,
  ListModelQualityJobDefinitionsRequest,
  RegisterDevicesRequest,
  CreateHyperParameterTuningJobRequest,
  UpdateActionRequest,
  CreateModelPackageRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient
import zio.stream.ZStream
object SageMakerMock extends Mock[SageMaker] {
  object DeleteAppImageConfig
      extends Effect[DeleteAppImageConfigRequest, AwsError, Unit]
  object ListTrainingJobs
      extends Stream[
        ListTrainingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly
      ]
  object ListTrainingJobsPaginated
      extends Effect[
        ListTrainingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly
      ]
  object ListImages
      extends Stream[
        ListImagesRequest,
        AwsError,
        zio.aws.sagemaker.model.Image.ReadOnly
      ]
  object ListImagesPaginated
      extends Effect[
        ListImagesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListImagesResponse.ReadOnly
      ]
  object DescribeStudioLifecycleConfig
      extends Effect[
        DescribeStudioLifecycleConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly
      ]
  object ListImageVersions
      extends Stream[
        ListImageVersionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ImageVersion.ReadOnly
      ]
  object ListImageVersionsPaginated
      extends Effect[
        ListImageVersionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly
      ]
  object DescribeWorkforce
      extends Effect[
        DescribeWorkforceRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly
      ]
  object ListLabelingJobs
      extends Stream[
        ListLabelingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly
      ]
  object ListLabelingJobsPaginated
      extends Effect[
        ListLabelingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly
      ]
  object DescribeDeviceFleet
      extends Effect[
        DescribeDeviceFleetRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly
      ]
  object CreateModelExplainabilityJobDefinition
      extends Effect[
        CreateModelExplainabilityJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly
      ]
  object RetryPipelineExecution
      extends Effect[
        RetryPipelineExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly
      ]
  object DescribeHumanTaskUi
      extends Effect[
        DescribeHumanTaskUiRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly
      ]
  object ListWorkforces
      extends Stream[
        ListWorkforcesRequest,
        AwsError,
        zio.aws.sagemaker.model.Workforce.ReadOnly
      ]
  object ListWorkforcesPaginated
      extends Effect[
        ListWorkforcesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly
      ]
  object ListUserProfiles
      extends Stream[
        ListUserProfilesRequest,
        AwsError,
        zio.aws.sagemaker.model.UserProfileDetails.ReadOnly
      ]
  object ListUserProfilesPaginated
      extends Effect[
        ListUserProfilesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly
      ]
  object DeleteHumanTaskUi
      extends Effect[
        DeleteHumanTaskUiRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteHumanTaskUiResponse.ReadOnly
      ]
  object ListModels
      extends Stream[
        ListModelsRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelSummary.ReadOnly
      ]
  object ListModelsPaginated
      extends Effect[
        ListModelsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelsResponse.ReadOnly
      ]
  object CreateAlgorithm
      extends Effect[
        CreateAlgorithmRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly
      ]
  object DescribeEdgeDeploymentPlan
      extends Effect[
        DescribeEdgeDeploymentPlanRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse.ReadOnly
      ]
  object UpdateHub
      extends Effect[
        UpdateHubRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateHubResponse.ReadOnly
      ]
  object CreateLabelingJob
      extends Effect[
        CreateLabelingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly
      ]
  object ListModelCardExportJobs
      extends Stream[
        ListModelCardExportJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly
      ]
  object ListModelCardExportJobsPaginated
      extends Effect[
        ListModelCardExportJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelCardExportJobsResponse.ReadOnly
      ]
  object ListMonitoringSchedules
      extends Stream[
        ListMonitoringSchedulesRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly
      ]
  object ListMonitoringSchedulesPaginated
      extends Effect[
        ListMonitoringSchedulesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly
      ]
  object GetScalingConfigurationRecommendation
      extends Effect[
        GetScalingConfigurationRecommendationRequest,
        AwsError,
        zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse.ReadOnly
      ]
  object CreateEdgeDeploymentStage
      extends Effect[CreateEdgeDeploymentStageRequest, AwsError, Unit]
  object StopInferenceExperiment
      extends Effect[
        StopInferenceExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.StopInferenceExperimentResponse.ReadOnly
      ]
  object DeleteTrial
      extends Effect[
        DeleteTrialRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly
      ]
  object AddAssociation
      extends Effect[
        AddAssociationRequest,
        AwsError,
        zio.aws.sagemaker.model.AddAssociationResponse.ReadOnly
      ]
  object ListPipelineExecutions
      extends Stream[
        ListPipelineExecutionsRequest,
        AwsError,
        zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly
      ]
  object ListPipelineExecutionsPaginated
      extends Effect[
        ListPipelineExecutionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly
      ]
  object GetLineageGroupPolicy
      extends Effect[
        GetLineageGroupPolicyRequest,
        AwsError,
        zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly
      ]
  object UpdateTrialComponent
      extends Effect[
        UpdateTrialComponentRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly
      ]
  object UpdateWorkteam
      extends Effect[
        UpdateWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly
      ]
  object DescribeAlgorithm
      extends Effect[
        DescribeAlgorithmRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly
      ]
  object CreateModelPackageGroup
      extends Effect[
        CreateModelPackageGroupRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly
      ]
  object CreateModelQualityJobDefinition
      extends Effect[
        CreateModelQualityJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly
      ]
  object DescribeModelPackage
      extends Effect[
        DescribeModelPackageRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly
      ]
  object ListWorkteams
      extends Stream[
        ListWorkteamsRequest,
        AwsError,
        zio.aws.sagemaker.model.Workteam.ReadOnly
      ]
  object ListWorkteamsPaginated
      extends Effect[
        ListWorkteamsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly
      ]
  object DeleteModelExplainabilityJobDefinition
      extends Effect[
        DeleteModelExplainabilityJobDefinitionRequest,
        AwsError,
        Unit
      ]
  object DeleteModelQualityJobDefinition
      extends Effect[DeleteModelQualityJobDefinitionRequest, AwsError, Unit]
  object DescribeTrial
      extends Effect[
        DescribeTrialRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeTrialResponse.ReadOnly
      ]
  object UpdateContext
      extends Effect[
        UpdateContextRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly
      ]
  object CreateModel
      extends Effect[
        CreateModelRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelResponse.ReadOnly
      ]
  object ListHyperParameterTuningJobs
      extends Stream[
        ListHyperParameterTuningJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
      ]
  object ListHyperParameterTuningJobsPaginated
      extends Effect[
        ListHyperParameterTuningJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly
      ]
  object ListModelQualityJobDefinitions
      extends Stream[
        ListModelQualityJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
      ]
  object ListModelQualityJobDefinitionsPaginated
      extends Effect[
        ListModelQualityJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly
      ]
  object UpdateInferenceExperiment
      extends Effect[
        UpdateInferenceExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateInferenceExperimentResponse.ReadOnly
      ]
  object CreateTrainingJob
      extends Effect[
        CreateTrainingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly
      ]
  object CreateTrialComponent
      extends Effect[
        CreateTrialComponentRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly
      ]
  object DescribeDomain
      extends Effect[
        DescribeDomainRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly
      ]
  object UpdateAction
      extends Effect[
        UpdateActionRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly
      ]
  object UpdateImage
      extends Effect[
        UpdateImageRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly
      ]
  object ListAlgorithms
      extends Stream[
        ListAlgorithmsRequest,
        AwsError,
        zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly
      ]
  object ListAlgorithmsPaginated
      extends Effect[
        ListAlgorithmsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly
      ]
  object DescribeDevice
      extends Effect[DescribeDeviceRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly,
        zio.aws.sagemaker.model.EdgeModel.ReadOnly
      ]]
  object DescribeDevicePaginated
      extends Effect[
        DescribeDeviceRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly
      ]
  object DeleteHub extends Effect[DeleteHubRequest, AwsError, Unit]
  object ListTags
      extends Stream[
        ListTagsRequest,
        AwsError,
        zio.aws.sagemaker.model.Tag.ReadOnly
      ]
  object ListTagsPaginated
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListTagsResponse.ReadOnly
      ]
  object AddTags
      extends Effect[
        AddTagsRequest,
        AwsError,
        zio.aws.sagemaker.model.AddTagsResponse.ReadOnly
      ]
  object ListDeviceFleets
      extends Stream[
        ListDeviceFleetsRequest,
        AwsError,
        zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly
      ]
  object ListDeviceFleetsPaginated
      extends Effect[
        ListDeviceFleetsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly
      ]
  object UpdateDeviceFleet
      extends Effect[UpdateDeviceFleetRequest, AwsError, Unit]
  object ListApps
      extends Stream[
        ListAppsRequest,
        AwsError,
        zio.aws.sagemaker.model.AppDetails.ReadOnly
      ]
  object ListAppsPaginated
      extends Effect[
        ListAppsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListAppsResponse.ReadOnly
      ]
  object ListInferenceExperiments
      extends Stream[
        ListInferenceExperimentsRequest,
        AwsError,
        zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly
      ]
  object ListInferenceExperimentsPaginated
      extends Effect[
        ListInferenceExperimentsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListInferenceExperimentsResponse.ReadOnly
      ]
  object CreateSpace
      extends Effect[
        CreateSpaceRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateSpaceResponse.ReadOnly
      ]
  object DeleteAction
      extends Effect[
        DeleteActionRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly
      ]
  object ListResourceCatalogs
      extends Stream[
        ListResourceCatalogsRequest,
        AwsError,
        zio.aws.sagemaker.model.ResourceCatalog.ReadOnly
      ]
  object ListResourceCatalogsPaginated
      extends Effect[
        ListResourceCatalogsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListResourceCatalogsResponse.ReadOnly
      ]
  object CreateTrial
      extends Effect[
        CreateTrialRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly
      ]
  object UpdateMonitoringAlert
      extends Effect[
        UpdateMonitoringAlertRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateMonitoringAlertResponse.ReadOnly
      ]
  object ListNotebookInstances
      extends Stream[
        ListNotebookInstancesRequest,
        AwsError,
        zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly
      ]
  object ListNotebookInstancesPaginated
      extends Effect[
        ListNotebookInstancesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly
      ]
  object StopEdgePackagingJob
      extends Effect[StopEdgePackagingJobRequest, AwsError, Unit]
  object UpdateModelCard
      extends Effect[
        UpdateModelCardRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateModelCardResponse.ReadOnly
      ]
  object DeleteImage
      extends Effect[
        DeleteImageRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteImageResponse.ReadOnly
      ]
  object CreateTransformJob
      extends Effect[
        CreateTransformJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly
      ]
  object UpdatePipeline
      extends Effect[
        UpdatePipelineRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly
      ]
  object StartPipelineExecution
      extends Effect[
        StartPipelineExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly
      ]
  object UpdateAppImageConfig
      extends Effect[
        UpdateAppImageConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly
      ]
  object CreateNotebookInstance
      extends Effect[
        CreateNotebookInstanceRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly
      ]
  object StartNotebookInstance
      extends Effect[StartNotebookInstanceRequest, AwsError, Unit]
  object CreateArtifact
      extends Effect[
        CreateArtifactRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly
      ]
  object DeregisterDevices
      extends Effect[DeregisterDevicesRequest, AwsError, Unit]
  object CreateCodeRepository
      extends Effect[
        CreateCodeRepositoryRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly
      ]
  object CreateContext
      extends Effect[
        CreateContextRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateContextResponse.ReadOnly
      ]
  object UpdateTrainingJob
      extends Effect[
        UpdateTrainingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly
      ]
  object ListEdgeDeploymentPlans
      extends Stream[
        ListEdgeDeploymentPlansRequest,
        AwsError,
        zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly
      ]
  object ListEdgeDeploymentPlansPaginated
      extends Effect[
        ListEdgeDeploymentPlansRequest,
        AwsError,
        zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse.ReadOnly
      ]
  object CreateEndpointConfig
      extends Effect[
        CreateEndpointConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly
      ]
  object UpdatePipelineExecution
      extends Effect[
        UpdatePipelineExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly
      ]
  object UpdateNotebookInstance
      extends Effect[
        UpdateNotebookInstanceRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateNotebookInstanceResponse.ReadOnly
      ]
  object UpdateMonitoringSchedule
      extends Effect[
        UpdateMonitoringScheduleRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateMonitoringScheduleResponse.ReadOnly
      ]
  object DescribeLineageGroup
      extends Effect[
        DescribeLineageGroupRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly
      ]
  object CreateAction
      extends Effect[
        CreateActionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateActionResponse.ReadOnly
      ]
  object UpdateUserProfile
      extends Effect[
        UpdateUserProfileRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly
      ]
  object ListModelBiasJobDefinitions
      extends Stream[
        ListModelBiasJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
      ]
  object ListModelBiasJobDefinitionsPaginated
      extends Effect[
        ListModelBiasJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly
      ]
  object ListHubs
      extends Stream[
        ListHubsRequest,
        AwsError,
        zio.aws.sagemaker.model.HubInfo.ReadOnly
      ]
  object ListHubsPaginated
      extends Effect[
        ListHubsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListHubsResponse.ReadOnly
      ]
  object QueryLineage
      extends Effect[
        QueryLineageRequest,
        AwsError,
        zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly
      ]
  object ListTrials
      extends Stream[
        ListTrialsRequest,
        AwsError,
        zio.aws.sagemaker.model.TrialSummary.ReadOnly
      ]
  object ListTrialsPaginated
      extends Effect[
        ListTrialsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly
      ]
  object CreateStudioLifecycleConfig
      extends Effect[
        CreateStudioLifecycleConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly
      ]
  object ListHumanTaskUis
      extends Stream[
        ListHumanTaskUisRequest,
        AwsError,
        zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly
      ]
  object ListHumanTaskUisPaginated
      extends Effect[
        ListHumanTaskUisRequest,
        AwsError,
        zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly
      ]
  object DescribeFlowDefinition
      extends Effect[
        DescribeFlowDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly
      ]
  object CreateFlowDefinition
      extends Effect[
        CreateFlowDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly
      ]
  object DeleteStudioLifecycleConfig
      extends Effect[DeleteStudioLifecycleConfigRequest, AwsError, Unit]
  object DescribeTrialComponent
      extends Effect[
        DescribeTrialComponentRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly
      ]
  object DescribeDataQualityJobDefinition
      extends Effect[
        DescribeDataQualityJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly
      ]
  object ListLabelingJobsForWorkteam
      extends Stream[
        ListLabelingJobsForWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly
      ]
  object ListLabelingJobsForWorkteamPaginated
      extends Effect[
        ListLabelingJobsForWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly
      ]
  object ListDomains
      extends Stream[
        ListDomainsRequest,
        AwsError,
        zio.aws.sagemaker.model.DomainDetails.ReadOnly
      ]
  object ListDomainsPaginated
      extends Effect[
        ListDomainsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly
      ]
  object CreateProcessingJob
      extends Effect[
        CreateProcessingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly
      ]
  object DescribeEdgePackagingJob
      extends Effect[
        DescribeEdgePackagingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly
      ]
  object GetDeviceFleetReport
      extends Effect[
        GetDeviceFleetReportRequest,
        AwsError,
        zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly
      ]
  object ListModelCards
      extends Stream[
        ListModelCardsRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelCardSummary.ReadOnly
      ]
  object ListModelCardsPaginated
      extends Effect[
        ListModelCardsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelCardsResponse.ReadOnly
      ]
  object UpdateNotebookInstanceLifecycleConfig
      extends Effect[
        UpdateNotebookInstanceLifecycleConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse.ReadOnly
      ]
  object DeleteEdgeDeploymentStage
      extends Effect[DeleteEdgeDeploymentStageRequest, AwsError, Unit]
  object CreateExperiment
      extends Effect[
        CreateExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly
      ]
  object DeleteModelCard extends Effect[DeleteModelCardRequest, AwsError, Unit]
  object StopLabelingJob extends Effect[StopLabelingJobRequest, AwsError, Unit]
  object ListModelMetadata
      extends Stream[
        ListModelMetadataRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly
      ]
  object ListModelMetadataPaginated
      extends Effect[
        ListModelMetadataRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly
      ]
  object UpdateWorkforce
      extends Effect[
        UpdateWorkforceRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly
      ]
  object ListDevices
      extends Stream[
        ListDevicesRequest,
        AwsError,
        zio.aws.sagemaker.model.DeviceSummary.ReadOnly
      ]
  object ListDevicesPaginated
      extends Effect[
        ListDevicesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly
      ]
  object ListAppImageConfigs
      extends Stream[
        ListAppImageConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly
      ]
  object ListAppImageConfigsPaginated
      extends Effect[
        ListAppImageConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly
      ]
  object DescribePipeline
      extends Effect[
        DescribePipelineRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribePipelineResponse.ReadOnly
      ]
  object EnableSagemakerServicecatalogPortfolio
      extends Effect[
        EnableSagemakerServicecatalogPortfolioRequest,
        AwsError,
        zio.aws.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse.ReadOnly
      ]
  object ListPipelines
      extends Stream[
        ListPipelinesRequest,
        AwsError,
        zio.aws.sagemaker.model.PipelineSummary.ReadOnly
      ]
  object ListPipelinesPaginated
      extends Effect[
        ListPipelinesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly
      ]
  object ListHubContents
      extends Stream[
        ListHubContentsRequest,
        AwsError,
        zio.aws.sagemaker.model.HubContentInfo.ReadOnly
      ]
  object ListHubContentsPaginated
      extends Effect[
        ListHubContentsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListHubContentsResponse.ReadOnly
      ]
  object DeleteMonitoringSchedule
      extends Effect[DeleteMonitoringScheduleRequest, AwsError, Unit]
  object DescribeNotebookInstanceLifecycleConfig
      extends Effect[
        DescribeNotebookInstanceLifecycleConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.sagemaker.model.ProjectSummary.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly
      ]
  object CreateApp
      extends Effect[
        CreateAppRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateAppResponse.ReadOnly
      ]
  object ListCompilationJobs
      extends Stream[
        ListCompilationJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly
      ]
  object ListCompilationJobsPaginated
      extends Effect[
        ListCompilationJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly
      ]
  object StopMonitoringSchedule
      extends Effect[StopMonitoringScheduleRequest, AwsError, Unit]
  object DeleteAlgorithm extends Effect[DeleteAlgorithmRequest, AwsError, Unit]
  object DeleteAssociation
      extends Effect[
        DeleteAssociationRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly
      ]
  object DeleteDataQualityJobDefinition
      extends Effect[DeleteDataQualityJobDefinitionRequest, AwsError, Unit]
  object ListEdgePackagingJobs
      extends Stream[
        ListEdgePackagingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly
      ]
  object ListEdgePackagingJobsPaginated
      extends Effect[
        ListEdgePackagingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly
      ]
  object GetSearchSuggestions
      extends Effect[
        GetSearchSuggestionsRequest,
        AwsError,
        zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly
      ]
  object ListModelPackages
      extends Stream[
        ListModelPackagesRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly
      ]
  object ListModelPackagesPaginated
      extends Effect[
        ListModelPackagesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelPackagesResponse.ReadOnly
      ]
  object DeleteEndpoint extends Effect[DeleteEndpointRequest, AwsError, Unit]
  object GetModelPackageGroupPolicy
      extends Effect[
        GetModelPackageGroupPolicyRequest,
        AwsError,
        zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly
      ]
  object DeleteHubContent
      extends Effect[DeleteHubContentRequest, AwsError, Unit]
  object DescribeNotebookInstance
      extends Effect[
        DescribeNotebookInstanceRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly
      ]
  object StopEdgeDeploymentStage
      extends Effect[StopEdgeDeploymentStageRequest, AwsError, Unit]
  object DescribeModelQualityJobDefinition
      extends Effect[
        DescribeModelQualityJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly
      ]
  object DeleteWorkforce
      extends Effect[
        DeleteWorkforceRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteWorkforceResponse.ReadOnly
      ]
  object DeleteModel extends Effect[DeleteModelRequest, AwsError, Unit]
  object ListProcessingJobs
      extends Stream[
        ListProcessingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly
      ]
  object ListProcessingJobsPaginated
      extends Effect[
        ListProcessingJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly
      ]
  object DeleteExperiment
      extends Effect[
        DeleteExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly
      ]
  object ListLineageGroups
      extends Stream[
        ListLineageGroupsRequest,
        AwsError,
        zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly
      ]
  object ListLineageGroupsPaginated
      extends Effect[
        ListLineageGroupsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly
      ]
  object DeleteArtifact
      extends Effect[
        DeleteArtifactRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly
      ]
  object ListSpaces
      extends Stream[
        ListSpacesRequest,
        AwsError,
        zio.aws.sagemaker.model.SpaceDetails.ReadOnly
      ]
  object ListSpacesPaginated
      extends Effect[
        ListSpacesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListSpacesResponse.ReadOnly
      ]
  object DeleteWorkteam
      extends Effect[
        DeleteWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteWorkteamResponse.ReadOnly
      ]
  object ListEndpointConfigs
      extends Stream[
        ListEndpointConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly
      ]
  object ListEndpointConfigsPaginated
      extends Effect[
        ListEndpointConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly
      ]
  object DeleteTrialComponent
      extends Effect[
        DeleteTrialComponentRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly
      ]
  object ListAliases
      extends Stream[ListAliasesRequest, AwsError, SageMakerImageVersionAlias]
  object ListAliasesPaginated
      extends Effect[
        ListAliasesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListAliasesResponse.ReadOnly
      ]
  object SendPipelineExecutionStepSuccess
      extends Effect[
        SendPipelineExecutionStepSuccessRequest,
        AwsError,
        zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly
      ]
  object DescribeFeatureMetadata
      extends Effect[
        DescribeFeatureMetadataRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeFeatureMetadataResponse.ReadOnly
      ]
  object CreateInferenceExperiment
      extends Effect[
        CreateInferenceExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateInferenceExperimentResponse.ReadOnly
      ]
  object ListAutoMLJobs
      extends Stream[
        ListAutoMlJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly
      ]
  object ListAutoMLJobsPaginated
      extends Effect[
        ListAutoMlJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly
      ]
  object DescribeModelCard
      extends Effect[
        DescribeModelCardRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelCardResponse.ReadOnly
      ]
  object DeleteDeviceFleet
      extends Effect[DeleteDeviceFleetRequest, AwsError, Unit]
  object ListSubscribedWorkteams
      extends Stream[
        ListSubscribedWorkteamsRequest,
        AwsError,
        zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly
      ]
  object ListSubscribedWorkteamsPaginated
      extends Effect[
        ListSubscribedWorkteamsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListSubscribedWorkteamsResponse.ReadOnly
      ]
  object UpdateDevices extends Effect[UpdateDevicesRequest, AwsError, Unit]
  object RenderUiTemplate
      extends Effect[
        RenderUiTemplateRequest,
        AwsError,
        zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly
      ]
  object CreateImage
      extends Effect[
        CreateImageRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateImageResponse.ReadOnly
      ]
  object DescribeLabelingJob
      extends Effect[
        DescribeLabelingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly
      ]
  object CreateHyperParameterTuningJob
      extends Effect[
        CreateHyperParameterTuningJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateHyperParameterTuningJobResponse.ReadOnly
      ]
  object CreateCompilationJob
      extends Effect[
        CreateCompilationJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly
      ]
  object DeleteApp extends Effect[DeleteAppRequest, AwsError, Unit]
  object DescribeModelCardExportJob
      extends Effect[
        DescribeModelCardExportJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelCardExportJobResponse.ReadOnly
      ]
  object CreateWorkforce
      extends Effect[
        CreateWorkforceRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly
      ]
  object AssociateTrialComponent
      extends Effect[
        AssociateTrialComponentRequest,
        AwsError,
        zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly
      ]
  object CreateDomain
      extends Effect[
        CreateDomainRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly
      ]
  object ListArtifacts
      extends Stream[
        ListArtifactsRequest,
        AwsError,
        zio.aws.sagemaker.model.ArtifactSummary.ReadOnly
      ]
  object ListArtifactsPaginated
      extends Effect[
        ListArtifactsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly
      ]
  object ListPipelineParametersForExecution
      extends Stream[
        ListPipelineParametersForExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.Parameter.ReadOnly
      ]
  object ListPipelineParametersForExecutionPaginated
      extends Effect[
        ListPipelineParametersForExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly
      ]
  object DisableSagemakerServicecatalogPortfolio
      extends Effect[
        DisableSagemakerServicecatalogPortfolioRequest,
        AwsError,
        zio.aws.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse.ReadOnly
      ]
  object CreateWorkteam
      extends Effect[
        CreateWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly
      ]
  object UpdateCodeRepository
      extends Effect[
        UpdateCodeRepositoryRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly
      ]
  object CreateMonitoringSchedule
      extends Effect[
        CreateMonitoringScheduleRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly
      ]
  object DeleteImageVersion
      extends Effect[
        DeleteImageVersionRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteImageVersionResponse.ReadOnly
      ]
  object ListTrialComponents
      extends Stream[
        ListTrialComponentsRequest,
        AwsError,
        zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly
      ]
  object ListTrialComponentsPaginated
      extends Effect[
        ListTrialComponentsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly
      ]
  object DescribeProcessingJob
      extends Effect[
        DescribeProcessingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly
      ]
  object ListCodeRepositories
      extends Stream[
        ListCodeRepositoriesRequest,
        AwsError,
        zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly
      ]
  object ListCodeRepositoriesPaginated
      extends Effect[
        ListCodeRepositoriesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly
      ]
  object ListAssociations
      extends Stream[
        ListAssociationsRequest,
        AwsError,
        zio.aws.sagemaker.model.AssociationSummary.ReadOnly
      ]
  object ListAssociationsPaginated
      extends Effect[
        ListAssociationsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly
      ]
  object ListMonitoringAlerts
      extends Stream[
        ListMonitoringAlertsRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly
      ]
  object ListMonitoringAlertsPaginated
      extends Effect[
        ListMonitoringAlertsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListMonitoringAlertsResponse.ReadOnly
      ]
  object DescribeModelBiasJobDefinition
      extends Effect[
        DescribeModelBiasJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionResponse.ReadOnly
      ]
  object StartMonitoringSchedule
      extends Effect[StartMonitoringScheduleRequest, AwsError, Unit]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly
      ]
  object ListTransformJobs
      extends Stream[
        ListTransformJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.TransformJobSummary.ReadOnly
      ]
  object ListTransformJobsPaginated
      extends Effect[
        ListTransformJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly
      ]
  object StopNotebookInstance
      extends Effect[StopNotebookInstanceRequest, AwsError, Unit]
  object DeleteFlowDefinition
      extends Effect[
        DeleteFlowDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteFlowDefinitionResponse.ReadOnly
      ]
  object ListFeatureGroups
      extends Stream[
        ListFeatureGroupsRequest,
        AwsError,
        zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly
      ]
  object ListFeatureGroupsPaginated
      extends Effect[
        ListFeatureGroupsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly
      ]
  object DescribeEndpoint
      extends Effect[
        DescribeEndpointRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly
      ]
  object UpdateDomain
      extends Effect[
        UpdateDomainRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly
      ]
  object StartInferenceExperiment
      extends Effect[
        StartInferenceExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.StartInferenceExperimentResponse.ReadOnly
      ]
  object ListModelExplainabilityJobDefinitions
      extends Stream[
        ListModelExplainabilityJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
      ]
  object ListModelExplainabilityJobDefinitionsPaginated
      extends Effect[
        ListModelExplainabilityJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse.ReadOnly
      ]
  object CreateAutoMLJob
      extends Effect[
        CreateAutoMlJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateAutoMlJobResponse.ReadOnly
      ]
  object CreateDeviceFleet
      extends Effect[CreateDeviceFleetRequest, AwsError, Unit]
  object DescribeAction
      extends Effect[
        DescribeActionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly
      ]
  object DescribeApp
      extends Effect[
        DescribeAppRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly
      ]
  object DescribeAutoMLJob
      extends Effect[
        DescribeAutoMlJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly
      ]
  object ListActions
      extends Stream[
        ListActionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ActionSummary.ReadOnly
      ]
  object ListActionsPaginated
      extends Effect[
        ListActionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListActionsResponse.ReadOnly
      ]
  object UpdateModelPackage
      extends Effect[
        UpdateModelPackageRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateModelPackageResponse.ReadOnly
      ]
  object DescribeImage
      extends Effect[
        DescribeImageRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly
      ]
  object DeleteContext
      extends Effect[
        DeleteContextRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly
      ]
  object CreateInferenceRecommendationsJob
      extends Effect[
        CreateInferenceRecommendationsJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly
      ]
  object CreateModelPackage
      extends Effect[
        CreateModelPackageRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly
      ]
  object DisassociateTrialComponent
      extends Effect[
        DisassociateTrialComponentRequest,
        AwsError,
        zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly
      ]
  object DescribeSpace
      extends Effect[
        DescribeSpaceRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeSpaceResponse.ReadOnly
      ]
  object UpdateFeatureMetadata
      extends Effect[UpdateFeatureMetadataRequest, AwsError, Unit]
  object StopTrainingJob extends Effect[StopTrainingJobRequest, AwsError, Unit]
  object CreateModelBiasJobDefinition
      extends Effect[
        CreateModelBiasJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly
      ]
  object DeleteNotebookInstance
      extends Effect[DeleteNotebookInstanceRequest, AwsError, Unit]
  object CreateFeatureGroup
      extends Effect[
        CreateFeatureGroupRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly
      ]
  object DescribeAppImageConfig
      extends Effect[
        DescribeAppImageConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly
      ]
  object ListModelCardVersions
      extends Stream[
        ListModelCardVersionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly
      ]
  object ListModelCardVersionsPaginated
      extends Effect[
        ListModelCardVersionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelCardVersionsResponse.ReadOnly
      ]
  object DescribeSubscribedWorkteam
      extends Effect[
        DescribeSubscribedWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly
      ]
  object DescribeModelPackageGroup
      extends Effect[
        DescribeModelPackageGroupRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly
      ]
  object CreatePresignedNotebookInstanceUrl
      extends Effect[
        CreatePresignedNotebookInstanceUrlRequest,
        AwsError,
        zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly
      ]
  object GetSagemakerServicecatalogPortfolioStatus
      extends Effect[
        GetSagemakerServicecatalogPortfolioStatusRequest,
        AwsError,
        zio.aws.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse.ReadOnly
      ]
  object DescribeInferenceExperiment
      extends Effect[
        DescribeInferenceExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeInferenceExperimentResponse.ReadOnly
      ]
  object ListStageDevices
      extends Stream[
        ListStageDevicesRequest,
        AwsError,
        zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly
      ]
  object ListStageDevicesPaginated
      extends Effect[
        ListStageDevicesRequest,
        AwsError,
        zio.aws.sagemaker.model.ListStageDevicesResponse.ReadOnly
      ]
  object DeletePipeline
      extends Effect[
        DeletePipelineRequest,
        AwsError,
        zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly
      ]
  object DescribePipelineExecution
      extends Effect[DescribePipelineExecutionRequest, AwsError, ReadOnly]
  object ListFlowDefinitions
      extends Stream[
        ListFlowDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly
      ]
  object ListFlowDefinitionsPaginated
      extends Effect[
        ListFlowDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly
      ]
  object ImportHubContent
      extends Effect[
        ImportHubContentRequest,
        AwsError,
        zio.aws.sagemaker.model.ImportHubContentResponse.ReadOnly
      ]
  object DescribeProject
      extends Effect[
        DescribeProjectRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly
      ]
  object ListNotebookInstanceLifecycleConfigs
      extends Stream[
        ListNotebookInstanceLifecycleConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
      ]
  object ListNotebookInstanceLifecycleConfigsPaginated
      extends Effect[
        ListNotebookInstanceLifecycleConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly
      ]
  object UpdateExperiment
      extends Effect[
        UpdateExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly
      ]
  object ListCandidatesForAutoMLJob
      extends Stream[
        ListCandidatesForAutoMlJobRequest,
        AwsError,
        zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly
      ]
  object ListCandidatesForAutoMLJobPaginated
      extends Effect[
        ListCandidatesForAutoMlJobRequest,
        AwsError,
        zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly
      ]
  object DeleteModelPackageGroup
      extends Effect[DeleteModelPackageGroupRequest, AwsError, Unit]
  object ListModelPackageGroups
      extends Stream[
        ListModelPackageGroupsRequest,
        AwsError,
        zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly
      ]
  object ListModelPackageGroupsPaginated
      extends Effect[
        ListModelPackageGroupsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly
      ]
  object ListHubContentVersions
      extends Stream[
        ListHubContentVersionsRequest,
        AwsError,
        zio.aws.sagemaker.model.HubContentInfo.ReadOnly
      ]
  object ListHubContentVersionsPaginated
      extends Effect[
        ListHubContentVersionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListHubContentVersionsResponse.ReadOnly
      ]
  object CreateEndpoint
      extends Effect[
        CreateEndpointRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly
      ]
  object DeleteDomain extends Effect[DeleteDomainRequest, AwsError, Unit]
  object DeleteInferenceExperiment
      extends Effect[
        DeleteInferenceExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteInferenceExperimentResponse.ReadOnly
      ]
  object DeleteModelPackageGroupPolicy
      extends Effect[DeleteModelPackageGroupPolicyRequest, AwsError, Unit]
  object ListMonitoringExecutions
      extends Stream[
        ListMonitoringExecutionsRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
      ]
  object ListMonitoringExecutionsPaginated
      extends Effect[
        ListMonitoringExecutionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly
      ]
  object DeleteModelBiasJobDefinition
      extends Effect[DeleteModelBiasJobDefinitionRequest, AwsError, Unit]
  object StartEdgeDeploymentStage
      extends Effect[StartEdgeDeploymentStageRequest, AwsError, Unit]
  object DescribeWorkteam
      extends Effect[
        DescribeWorkteamRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeWorkteamResponse.ReadOnly
      ]
  object UpdateEndpoint
      extends Effect[
        UpdateEndpointRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly
      ]
  object CreateEdgeDeploymentPlan
      extends Effect[
        CreateEdgeDeploymentPlanRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse.ReadOnly
      ]
  object ListTrainingJobsForHyperParameterTuningJob
      extends Stream[
        ListTrainingJobsForHyperParameterTuningJobRequest,
        AwsError,
        zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
      ]
  object ListTrainingJobsForHyperParameterTuningJobPaginated
      extends Effect[
        ListTrainingJobsForHyperParameterTuningJobRequest,
        AwsError,
        zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse.ReadOnly
      ]
  object ListEndpoints
      extends Stream[
        ListEndpointsRequest,
        AwsError,
        zio.aws.sagemaker.model.EndpointSummary.ReadOnly
      ]
  object ListEndpointsPaginated
      extends Effect[
        ListEndpointsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly
      ]
  object ListContexts
      extends Stream[
        ListContextsRequest,
        AwsError,
        zio.aws.sagemaker.model.ContextSummary.ReadOnly
      ]
  object ListContextsPaginated
      extends Effect[
        ListContextsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListContextsResponse.ReadOnly
      ]
  object DescribeImageVersion
      extends Effect[
        DescribeImageVersionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly
      ]
  object StopAutoMLJob extends Effect[StopAutoMlJobRequest, AwsError, Unit]
  object DescribeMonitoringSchedule
      extends Effect[
        DescribeMonitoringScheduleRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly
      ]
  object DeleteFeatureGroup
      extends Effect[DeleteFeatureGroupRequest, AwsError, Unit]
  object CreateHumanTaskUi
      extends Effect[
        CreateHumanTaskUiRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateHumanTaskUiResponse.ReadOnly
      ]
  object CreateAppImageConfig
      extends Effect[
        CreateAppImageConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly
      ]
  object DescribeUserProfile
      extends Effect[
        DescribeUserProfileRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly
      ]
  object StopHyperParameterTuningJob
      extends Effect[StopHyperParameterTuningJobRequest, AwsError, Unit]
  object Search
      extends Stream[
        SearchRequest,
        AwsError,
        zio.aws.sagemaker.model.SearchRecord.ReadOnly
      ]
  object SearchPaginated
      extends Effect[
        SearchRequest,
        AwsError,
        zio.aws.sagemaker.model.SearchResponse.ReadOnly
      ]
  object ListExperiments
      extends Stream[
        ListExperimentsRequest,
        AwsError,
        zio.aws.sagemaker.model.ExperimentSummary.ReadOnly
      ]
  object ListExperimentsPaginated
      extends Effect[
        ListExperimentsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly
      ]
  object DescribeCodeRepository
      extends Effect[
        DescribeCodeRepositoryRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeCodeRepositoryResponse.ReadOnly
      ]
  object DeleteUserProfile
      extends Effect[DeleteUserProfileRequest, AwsError, Unit]
  object PutModelPackageGroupPolicy
      extends Effect[
        PutModelPackageGroupPolicyRequest,
        AwsError,
        zio.aws.sagemaker.model.PutModelPackageGroupPolicyResponse.ReadOnly
      ]
  object UpdateSpace
      extends Effect[
        UpdateSpaceRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateSpaceResponse.ReadOnly
      ]
  object StopPipelineExecution
      extends Effect[
        StopPipelineExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.StopPipelineExecutionResponse.ReadOnly
      ]
  object ListPipelineExecutionSteps
      extends Stream[
        ListPipelineExecutionStepsRequest,
        AwsError,
        zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly
      ]
  object ListPipelineExecutionStepsPaginated
      extends Effect[
        ListPipelineExecutionStepsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly
      ]
  object DeleteModelPackage
      extends Effect[DeleteModelPackageRequest, AwsError, Unit]
  object DescribePipelineDefinitionForExecution
      extends Effect[
        DescribePipelineDefinitionForExecutionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly
      ]
  object DeleteNotebookInstanceLifecycleConfig
      extends Effect[
        DeleteNotebookInstanceLifecycleConfigRequest,
        AwsError,
        Unit
      ]
  object ListInferenceRecommendationsJobSteps
      extends Stream[
        ListInferenceRecommendationsJobStepsRequest,
        AwsError,
        zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly
      ]
  object ListInferenceRecommendationsJobStepsPaginated
      extends Effect[
        ListInferenceRecommendationsJobStepsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse.ReadOnly
      ]
  object DeleteCodeRepository
      extends Effect[DeleteCodeRepositoryRequest, AwsError, Unit]
  object ListMonitoringAlertHistory
      extends Stream[
        ListMonitoringAlertHistoryRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly
      ]
  object ListMonitoringAlertHistoryPaginated
      extends Effect[
        ListMonitoringAlertHistoryRequest,
        AwsError,
        zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse.ReadOnly
      ]
  object DescribeFeatureGroup
      extends Effect[
        DescribeFeatureGroupRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly,
          zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
        ]
      ]
  object DescribeFeatureGroupPaginated
      extends Effect[
        DescribeFeatureGroupRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly
      ]
  object UpdateArtifact
      extends Effect[
        UpdateArtifactRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly
      ]
  object DescribeHub
      extends Effect[
        DescribeHubRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeHubResponse.ReadOnly
      ]
  object StopProcessingJob
      extends Effect[StopProcessingJobRequest, AwsError, Unit]
  object DeleteSpace extends Effect[DeleteSpaceRequest, AwsError, Unit]
  object StopInferenceRecommendationsJob
      extends Effect[StopInferenceRecommendationsJobRequest, AwsError, Unit]
  object DeleteProject extends Effect[DeleteProjectRequest, AwsError, Unit]
  object UpdateTrial
      extends Effect[
        UpdateTrialRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly
      ]
  object CreateModelCardExportJob
      extends Effect[
        CreateModelCardExportJobRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelCardExportJobResponse.ReadOnly
      ]
  object DescribeHubContent
      extends Effect[
        DescribeHubContentRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeHubContentResponse.ReadOnly
      ]
  object CreateImageVersion
      extends Effect[
        CreateImageVersionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly
      ]
  object DeleteTags
      extends Effect[
        DeleteTagsRequest,
        AwsError,
        zio.aws.sagemaker.model.DeleteTagsResponse.ReadOnly
      ]
  object CreatePipeline
      extends Effect[
        CreatePipelineRequest,
        AwsError,
        zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly
      ]
  object DescribeArtifact
      extends Effect[
        DescribeArtifactRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly
      ]
  object UpdateImageVersion
      extends Effect[
        UpdateImageVersionRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateImageVersionResponse.ReadOnly
      ]
  object DescribeContext
      extends Effect[
        DescribeContextRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly
      ]
  object DescribeTrainingJob
      extends Effect[
        DescribeTrainingJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly
      ]
  object SendPipelineExecutionStepFailure
      extends Effect[
        SendPipelineExecutionStepFailureRequest,
        AwsError,
        zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly
      ]
  object ListStudioLifecycleConfigs
      extends Stream[
        ListStudioLifecycleConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly
      ]
  object ListStudioLifecycleConfigsPaginated
      extends Effect[
        ListStudioLifecycleConfigsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly
      ]
  object UpdateEndpointWeightsAndCapacities
      extends Effect[
        UpdateEndpointWeightsAndCapacitiesRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly
      ]
  object CreateNotebookInstanceLifecycleConfig
      extends Effect[
        CreateNotebookInstanceLifecycleConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly
      ]
  object CreateAutoMLJobV2
      extends Effect[
        CreateAutoMlJobV2Request,
        AwsError,
        zio.aws.sagemaker.model.CreateAutoMlJobV2Response.ReadOnly
      ]
  object CreateEdgePackagingJob
      extends Effect[CreateEdgePackagingJobRequest, AwsError, Unit]
  object UpdateFeatureGroup
      extends Effect[
        UpdateFeatureGroupRequest,
        AwsError,
        zio.aws.sagemaker.model.UpdateFeatureGroupResponse.ReadOnly
      ]
  object DescribeAutoMLJobV2
      extends Effect[
        DescribeAutoMlJobV2Request,
        AwsError,
        zio.aws.sagemaker.model.DescribeAutoMlJobV2Response.ReadOnly
      ]
  object CreateModelCard
      extends Effect[
        CreateModelCardRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateModelCardResponse.ReadOnly
      ]
  object DescribeInferenceRecommendationsJob
      extends Effect[
        DescribeInferenceRecommendationsJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly
      ]
  object CreatePresignedDomainUrl
      extends Effect[
        CreatePresignedDomainUrlRequest,
        AwsError,
        zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly
      ]
  object DescribeModel
      extends Effect[
        DescribeModelRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly
      ]
  object RegisterDevices extends Effect[RegisterDevicesRequest, AwsError, Unit]
  object DescribeCompilationJob
      extends Effect[
        DescribeCompilationJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly
      ]
  object ListDataQualityJobDefinitions
      extends Stream[
        ListDataQualityJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
      ]
  object ListDataQualityJobDefinitionsPaginated
      extends Effect[
        ListDataQualityJobDefinitionsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListDataQualityJobDefinitionsResponse.ReadOnly
      ]
  object StopTransformJob
      extends Effect[StopTransformJobRequest, AwsError, Unit]
  object DeleteEndpointConfig
      extends Effect[DeleteEndpointConfigRequest, AwsError, Unit]
  object StopCompilationJob
      extends Effect[StopCompilationJobRequest, AwsError, Unit]
  object DescribeModelExplainabilityJobDefinition
      extends Effect[
        DescribeModelExplainabilityJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly
      ]
  object DescribeTransformJob
      extends Effect[
        DescribeTransformJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly
      ]
  object DeleteEdgeDeploymentPlan
      extends Effect[DeleteEdgeDeploymentPlanRequest, AwsError, Unit]
  object CreateUserProfile
      extends Effect[
        CreateUserProfileRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly
      ]
  object CreateDataQualityJobDefinition
      extends Effect[
        CreateDataQualityJobDefinitionRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly
      ]
  object DescribeExperiment
      extends Effect[
        DescribeExperimentRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly
      ]
  object ListInferenceRecommendationsJobs
      extends Stream[
        ListInferenceRecommendationsJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly
      ]
  object ListInferenceRecommendationsJobsPaginated
      extends Effect[
        ListInferenceRecommendationsJobsRequest,
        AwsError,
        zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly
      ]
  object DescribeEndpointConfig
      extends Effect[
        DescribeEndpointConfigRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly
      ]
  object DescribeHyperParameterTuningJob
      extends Effect[
        DescribeHyperParameterTuningJobRequest,
        AwsError,
        zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly
      ]
  object CreateHub
      extends Effect[
        CreateHubRequest,
        AwsError,
        zio.aws.sagemaker.model.CreateHubResponse.ReadOnly
      ]
  object BatchDescribeModelPackage
      extends Effect[
        BatchDescribeModelPackageRequest,
        AwsError,
        zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SageMaker] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SageMaker] { rts =>
        ZIO.succeed {
          new SageMaker {
            val api: SageMakerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SageMaker = this
            def deleteAppImageConfig(
                request: DeleteAppImageConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteAppImageConfig, request)
            def listTrainingJobs(request: ListTrainingJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTrainingJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTrainingJobsPaginated(request: ListTrainingJobsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly
            ] = proxy(ListTrainingJobsPaginated, request)
            def listImages(
                request: ListImagesRequest
            ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Image.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListImages, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listImagesPaginated(request: ListImagesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListImagesResponse.ReadOnly
            ] = proxy(ListImagesPaginated, request)
            def describeStudioLifecycleConfig(
                request: DescribeStudioLifecycleConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly
            ] = proxy(DescribeStudioLifecycleConfig, request)
            def listImageVersions(request: ListImageVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ImageVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageVersionsPaginated(
                request: ListImageVersionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly
            ] = proxy(ListImageVersionsPaginated, request)
            def describeWorkforce(request: DescribeWorkforceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly
            ] = proxy(DescribeWorkforce, request)
            def listLabelingJobs(request: ListLabelingJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLabelingJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLabelingJobsPaginated(request: ListLabelingJobsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly
            ] = proxy(ListLabelingJobsPaginated, request)
            def describeDeviceFleet(request: DescribeDeviceFleetRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly
            ] = proxy(DescribeDeviceFleet, request)
            def createModelExplainabilityJobDefinition(
                request: CreateModelExplainabilityJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly
            ] = proxy(CreateModelExplainabilityJobDefinition, request)
            def retryPipelineExecution(
                request: RetryPipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly
            ] = proxy(RetryPipelineExecution, request)
            def describeHumanTaskUi(request: DescribeHumanTaskUiRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly
            ] = proxy(DescribeHumanTaskUi, request)
            def listWorkforces(request: ListWorkforcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.Workforce.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkforces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkforcesPaginated(request: ListWorkforcesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly
            ] = proxy(ListWorkforcesPaginated, request)
            def listUserProfiles(request: ListUserProfilesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.UserProfileDetails.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUserProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUserProfilesPaginated(request: ListUserProfilesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly
            ] = proxy(ListUserProfilesPaginated, request)
            def deleteHumanTaskUi(request: DeleteHumanTaskUiRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteHumanTaskUiResponse.ReadOnly
            ] = proxy(DeleteHumanTaskUi, request)
            def listModels(request: ListModelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelsPaginated(request: ListModelsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelsResponse.ReadOnly
            ] = proxy(ListModelsPaginated, request)
            def createAlgorithm(request: CreateAlgorithmRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly
            ] = proxy(CreateAlgorithm, request)
            def describeEdgeDeploymentPlan(
                request: DescribeEdgeDeploymentPlanRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse.ReadOnly
            ] = proxy(DescribeEdgeDeploymentPlan, request)
            def updateHub(request: UpdateHubRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateHubResponse.ReadOnly
            ] = proxy(UpdateHub, request)
            def createLabelingJob(request: CreateLabelingJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly
            ] = proxy(CreateLabelingJob, request)
            def listModelCardExportJobs(
                request: ListModelCardExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelCardExportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelCardExportJobsPaginated(
                request: ListModelCardExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelCardExportJobsResponse.ReadOnly
            ] = proxy(ListModelCardExportJobsPaginated, request)
            def listMonitoringSchedules(
                request: ListMonitoringSchedulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMonitoringSchedules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMonitoringSchedulesPaginated(
                request: ListMonitoringSchedulesRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly
            ] = proxy(ListMonitoringSchedulesPaginated, request)
            def getScalingConfigurationRecommendation(
                request: GetScalingConfigurationRecommendationRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse.ReadOnly
            ] = proxy(GetScalingConfigurationRecommendation, request)
            def createEdgeDeploymentStage(
                request: CreateEdgeDeploymentStageRequest
            ): IO[AwsError, Unit] = proxy(CreateEdgeDeploymentStage, request)
            def stopInferenceExperiment(
                request: StopInferenceExperimentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.StopInferenceExperimentResponse.ReadOnly
            ] = proxy(StopInferenceExperiment, request)
            def deleteTrial(request: DeleteTrialRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly
            ] = proxy(DeleteTrial, request)
            def addAssociation(request: AddAssociationRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.AddAssociationResponse.ReadOnly
            ] = proxy(AddAssociation, request)
            def listPipelineExecutions(
                request: ListPipelineExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPipelineExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPipelineExecutionsPaginated(
                request: ListPipelineExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly
            ] = proxy(ListPipelineExecutionsPaginated, request)
            def getLineageGroupPolicy(
                request: GetLineageGroupPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly
            ] = proxy(GetLineageGroupPolicy, request)
            def updateTrialComponent(request: UpdateTrialComponentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly
            ] = proxy(UpdateTrialComponent, request)
            def updateWorkteam(request: UpdateWorkteamRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly
            ] = proxy(UpdateWorkteam, request)
            def describeAlgorithm(request: DescribeAlgorithmRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly
            ] = proxy(DescribeAlgorithm, request)
            def createModelPackageGroup(
                request: CreateModelPackageGroupRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly
            ] = proxy(CreateModelPackageGroup, request)
            def createModelQualityJobDefinition(
                request: CreateModelQualityJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly
            ] = proxy(CreateModelQualityJobDefinition, request)
            def describeModelPackage(request: DescribeModelPackageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly
            ] = proxy(DescribeModelPackage, request)
            def listWorkteams(request: ListWorkteamsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.Workteam.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkteams, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkteamsPaginated(request: ListWorkteamsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly
            ] = proxy(ListWorkteamsPaginated, request)
            def deleteModelExplainabilityJobDefinition(
                request: DeleteModelExplainabilityJobDefinitionRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteModelExplainabilityJobDefinition, request)
            def deleteModelQualityJobDefinition(
                request: DeleteModelQualityJobDefinitionRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteModelQualityJobDefinition, request)
            def describeTrial(request: DescribeTrialRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeTrialResponse.ReadOnly
            ] = proxy(DescribeTrial, request)
            def updateContext(request: UpdateContextRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly
            ] = proxy(UpdateContext, request)
            def createModel(request: CreateModelRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelResponse.ReadOnly
            ] = proxy(CreateModel, request)
            def listHyperParameterTuningJobs(
                request: ListHyperParameterTuningJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHyperParameterTuningJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHyperParameterTuningJobsPaginated(
                request: ListHyperParameterTuningJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly
            ] = proxy(ListHyperParameterTuningJobsPaginated, request)
            def listModelQualityJobDefinitions(
                request: ListModelQualityJobDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelQualityJobDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelQualityJobDefinitionsPaginated(
                request: ListModelQualityJobDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly
            ] = proxy(ListModelQualityJobDefinitionsPaginated, request)
            def updateInferenceExperiment(
                request: UpdateInferenceExperimentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateInferenceExperimentResponse.ReadOnly
            ] = proxy(UpdateInferenceExperiment, request)
            def createTrainingJob(request: CreateTrainingJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly
            ] = proxy(CreateTrainingJob, request)
            def createTrialComponent(request: CreateTrialComponentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly
            ] = proxy(CreateTrialComponent, request)
            def describeDomain(request: DescribeDomainRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly
            ] = proxy(DescribeDomain, request)
            def updateAction(request: UpdateActionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly
            ] = proxy(UpdateAction, request)
            def updateProject(request: UpdateProjectRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly
            ] = proxy(UpdateProject, request)
            def updateImage(request: UpdateImageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly
            ] = proxy(UpdateImage, request)
            def listAlgorithms(request: ListAlgorithmsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAlgorithms, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAlgorithmsPaginated(request: ListAlgorithmsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly
            ] = proxy(ListAlgorithmsPaginated, request)
            def describeDevice(
                request: DescribeDeviceRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly,
              zio.aws.sagemaker.model.EdgeModel.ReadOnly
            ]] = proxy(DescribeDevice, request)
            def describeDevicePaginated(request: DescribeDeviceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly
            ] = proxy(DescribeDevicePaginated, request)
            def deleteHub(request: DeleteHubRequest): IO[AwsError, Unit] =
              proxy(DeleteHub, request)
            def listTags(
                request: ListTagsRequest
            ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Tag.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTags, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsPaginated(
                request: ListTagsRequest
            ): IO[AwsError, zio.aws.sagemaker.model.ListTagsResponse.ReadOnly] =
              proxy(ListTagsPaginated, request)
            def addTags(
                request: AddTagsRequest
            ): IO[AwsError, zio.aws.sagemaker.model.AddTagsResponse.ReadOnly] =
              proxy(AddTags, request)
            def listDeviceFleets(request: ListDeviceFleetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDeviceFleets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDeviceFleetsPaginated(request: ListDeviceFleetsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly
            ] = proxy(ListDeviceFleetsPaginated, request)
            def updateDeviceFleet(
                request: UpdateDeviceFleetRequest
            ): IO[AwsError, Unit] = proxy(UpdateDeviceFleet, request)
            def listApps(request: ListAppsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.AppDetails.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAppsPaginated(
                request: ListAppsRequest
            ): IO[AwsError, zio.aws.sagemaker.model.ListAppsResponse.ReadOnly] =
              proxy(ListAppsPaginated, request)
            def listInferenceExperiments(
                request: ListInferenceExperimentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceExperiments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceExperimentsPaginated(
                request: ListInferenceExperimentsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListInferenceExperimentsResponse.ReadOnly
            ] = proxy(ListInferenceExperimentsPaginated, request)
            def createSpace(request: CreateSpaceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateSpaceResponse.ReadOnly
            ] = proxy(CreateSpace, request)
            def deleteAction(request: DeleteActionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly
            ] = proxy(DeleteAction, request)
            def listResourceCatalogs(
                request: ListResourceCatalogsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ResourceCatalog.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResourceCatalogs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResourceCatalogsPaginated(
                request: ListResourceCatalogsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListResourceCatalogsResponse.ReadOnly
            ] = proxy(ListResourceCatalogsPaginated, request)
            def createTrial(request: CreateTrialRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly
            ] = proxy(CreateTrial, request)
            def updateMonitoringAlert(
                request: UpdateMonitoringAlertRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateMonitoringAlertResponse.ReadOnly
            ] = proxy(UpdateMonitoringAlert, request)
            def listNotebookInstances(
                request: ListNotebookInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotebookInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotebookInstancesPaginated(
                request: ListNotebookInstancesRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly
            ] = proxy(ListNotebookInstancesPaginated, request)
            def stopEdgePackagingJob(
                request: StopEdgePackagingJobRequest
            ): IO[AwsError, Unit] = proxy(StopEdgePackagingJob, request)
            def updateModelCard(request: UpdateModelCardRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateModelCardResponse.ReadOnly
            ] = proxy(UpdateModelCard, request)
            def deleteImage(request: DeleteImageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteImageResponse.ReadOnly
            ] = proxy(DeleteImage, request)
            def createTransformJob(request: CreateTransformJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly
            ] = proxy(CreateTransformJob, request)
            def updatePipeline(request: UpdatePipelineRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly
            ] = proxy(UpdatePipeline, request)
            def startPipelineExecution(
                request: StartPipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly
            ] = proxy(StartPipelineExecution, request)
            def updateAppImageConfig(request: UpdateAppImageConfigRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly
            ] = proxy(UpdateAppImageConfig, request)
            def createNotebookInstance(
                request: CreateNotebookInstanceRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly
            ] = proxy(CreateNotebookInstance, request)
            def startNotebookInstance(
                request: StartNotebookInstanceRequest
            ): IO[AwsError, Unit] = proxy(StartNotebookInstance, request)
            def createArtifact(request: CreateArtifactRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly
            ] = proxy(CreateArtifact, request)
            def deregisterDevices(
                request: DeregisterDevicesRequest
            ): IO[AwsError, Unit] = proxy(DeregisterDevices, request)
            def createCodeRepository(request: CreateCodeRepositoryRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly
            ] = proxy(CreateCodeRepository, request)
            def createContext(request: CreateContextRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateContextResponse.ReadOnly
            ] = proxy(CreateContext, request)
            def updateTrainingJob(request: UpdateTrainingJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly
            ] = proxy(UpdateTrainingJob, request)
            def listEdgeDeploymentPlans(
                request: ListEdgeDeploymentPlansRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEdgeDeploymentPlans, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEdgeDeploymentPlansPaginated(
                request: ListEdgeDeploymentPlansRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse.ReadOnly
            ] = proxy(ListEdgeDeploymentPlansPaginated, request)
            def createEndpointConfig(request: CreateEndpointConfigRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly
            ] = proxy(CreateEndpointConfig, request)
            def updatePipelineExecution(
                request: UpdatePipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly
            ] = proxy(UpdatePipelineExecution, request)
            def updateNotebookInstance(
                request: UpdateNotebookInstanceRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateNotebookInstanceResponse.ReadOnly
            ] = proxy(UpdateNotebookInstance, request)
            def updateMonitoringSchedule(
                request: UpdateMonitoringScheduleRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateMonitoringScheduleResponse.ReadOnly
            ] = proxy(UpdateMonitoringSchedule, request)
            def describeLineageGroup(request: DescribeLineageGroupRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly
            ] = proxy(DescribeLineageGroup, request)
            def createAction(request: CreateActionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateActionResponse.ReadOnly
            ] = proxy(CreateAction, request)
            def updateUserProfile(request: UpdateUserProfileRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly
            ] = proxy(UpdateUserProfile, request)
            def listModelBiasJobDefinitions(
                request: ListModelBiasJobDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelBiasJobDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelBiasJobDefinitionsPaginated(
                request: ListModelBiasJobDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly
            ] = proxy(ListModelBiasJobDefinitionsPaginated, request)
            def listHubs(request: ListHubsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.HubInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHubs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHubsPaginated(
                request: ListHubsRequest
            ): IO[AwsError, zio.aws.sagemaker.model.ListHubsResponse.ReadOnly] =
              proxy(ListHubsPaginated, request)
            def queryLineage(request: QueryLineageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly
            ] = proxy(QueryLineage, request)
            def listTrials(request: ListTrialsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.TrialSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTrials, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTrialsPaginated(request: ListTrialsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly
            ] = proxy(ListTrialsPaginated, request)
            def createStudioLifecycleConfig(
                request: CreateStudioLifecycleConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly
            ] = proxy(CreateStudioLifecycleConfig, request)
            def listHumanTaskUis(request: ListHumanTaskUisRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHumanTaskUis, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHumanTaskUisPaginated(request: ListHumanTaskUisRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly
            ] = proxy(ListHumanTaskUisPaginated, request)
            def describeFlowDefinition(
                request: DescribeFlowDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly
            ] = proxy(DescribeFlowDefinition, request)
            def createFlowDefinition(request: CreateFlowDefinitionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly
            ] = proxy(CreateFlowDefinition, request)
            def deleteStudioLifecycleConfig(
                request: DeleteStudioLifecycleConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteStudioLifecycleConfig, request)
            def describeTrialComponent(
                request: DescribeTrialComponentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly
            ] = proxy(DescribeTrialComponent, request)
            def describeDataQualityJobDefinition(
                request: DescribeDataQualityJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly
            ] = proxy(DescribeDataQualityJobDefinition, request)
            def listLabelingJobsForWorkteam(
                request: ListLabelingJobsForWorkteamRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLabelingJobsForWorkteam, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLabelingJobsForWorkteamPaginated(
                request: ListLabelingJobsForWorkteamRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly
            ] = proxy(ListLabelingJobsForWorkteamPaginated, request)
            def listDomains(request: ListDomainsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.DomainDetails.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDomains, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDomainsPaginated(request: ListDomainsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly
            ] = proxy(ListDomainsPaginated, request)
            def createProcessingJob(request: CreateProcessingJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly
            ] = proxy(CreateProcessingJob, request)
            def describeEdgePackagingJob(
                request: DescribeEdgePackagingJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly
            ] = proxy(DescribeEdgePackagingJob, request)
            def getDeviceFleetReport(request: GetDeviceFleetReportRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly
            ] = proxy(GetDeviceFleetReport, request)
            def listModelCards(request: ListModelCardsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelCardSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelCards, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelCardsPaginated(request: ListModelCardsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelCardsResponse.ReadOnly
            ] = proxy(ListModelCardsPaginated, request)
            def updateNotebookInstanceLifecycleConfig(
                request: UpdateNotebookInstanceLifecycleConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse.ReadOnly
            ] = proxy(UpdateNotebookInstanceLifecycleConfig, request)
            def deleteEdgeDeploymentStage(
                request: DeleteEdgeDeploymentStageRequest
            ): IO[AwsError, Unit] = proxy(DeleteEdgeDeploymentStage, request)
            def createExperiment(request: CreateExperimentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly
            ] = proxy(CreateExperiment, request)
            def deleteModelCard(
                request: DeleteModelCardRequest
            ): IO[AwsError, Unit] = proxy(DeleteModelCard, request)
            def stopLabelingJob(
                request: StopLabelingJobRequest
            ): IO[AwsError, Unit] = proxy(StopLabelingJob, request)
            def listModelMetadata(request: ListModelMetadataRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelMetadata, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelMetadataPaginated(
                request: ListModelMetadataRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly
            ] = proxy(ListModelMetadataPaginated, request)
            def updateWorkforce(request: UpdateWorkforceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly
            ] = proxy(UpdateWorkforce, request)
            def listDevices(request: ListDevicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.DeviceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDevices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDevicesPaginated(request: ListDevicesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly
            ] = proxy(ListDevicesPaginated, request)
            def listAppImageConfigs(
                request: ListAppImageConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAppImageConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAppImageConfigsPaginated(
                request: ListAppImageConfigsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly
            ] = proxy(ListAppImageConfigsPaginated, request)
            def describePipeline(request: DescribePipelineRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribePipelineResponse.ReadOnly
            ] = proxy(DescribePipeline, request)
            def enableSagemakerServicecatalogPortfolio(
                request: EnableSagemakerServicecatalogPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse.ReadOnly
            ] = proxy(EnableSagemakerServicecatalogPortfolio, request)
            def listPipelines(request: ListPipelinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.PipelineSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPipelinesPaginated(request: ListPipelinesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly
            ] = proxy(ListPipelinesPaginated, request)
            def listHubContents(request: ListHubContentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.HubContentInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHubContents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHubContentsPaginated(request: ListHubContentsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListHubContentsResponse.ReadOnly
            ] = proxy(ListHubContentsPaginated, request)
            def deleteMonitoringSchedule(
                request: DeleteMonitoringScheduleRequest
            ): IO[AwsError, Unit] = proxy(DeleteMonitoringSchedule, request)
            def describeNotebookInstanceLifecycleConfig(
                request: DescribeNotebookInstanceLifecycleConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly
            ] = proxy(DescribeNotebookInstanceLifecycleConfig, request)
            def listProjects(request: ListProjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ProjectSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProjects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProjectsPaginated(request: ListProjectsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly
            ] = proxy(ListProjectsPaginated, request)
            def createApp(request: CreateAppRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateAppResponse.ReadOnly
            ] = proxy(CreateApp, request)
            def listCompilationJobs(
                request: ListCompilationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCompilationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCompilationJobsPaginated(
                request: ListCompilationJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly
            ] = proxy(ListCompilationJobsPaginated, request)
            def stopMonitoringSchedule(
                request: StopMonitoringScheduleRequest
            ): IO[AwsError, Unit] = proxy(StopMonitoringSchedule, request)
            def deleteAlgorithm(
                request: DeleteAlgorithmRequest
            ): IO[AwsError, Unit] = proxy(DeleteAlgorithm, request)
            def deleteAssociation(request: DeleteAssociationRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly
            ] = proxy(DeleteAssociation, request)
            def deleteDataQualityJobDefinition(
                request: DeleteDataQualityJobDefinitionRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteDataQualityJobDefinition, request)
            def listEdgePackagingJobs(
                request: ListEdgePackagingJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEdgePackagingJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEdgePackagingJobsPaginated(
                request: ListEdgePackagingJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly
            ] = proxy(ListEdgePackagingJobsPaginated, request)
            def getSearchSuggestions(request: GetSearchSuggestionsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly
            ] = proxy(GetSearchSuggestions, request)
            def listModelPackages(request: ListModelPackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelPackages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelPackagesPaginated(
                request: ListModelPackagesRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelPackagesResponse.ReadOnly
            ] = proxy(ListModelPackagesPaginated, request)
            def deleteEndpoint(
                request: DeleteEndpointRequest
            ): IO[AwsError, Unit] = proxy(DeleteEndpoint, request)
            def getModelPackageGroupPolicy(
                request: GetModelPackageGroupPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly
            ] = proxy(GetModelPackageGroupPolicy, request)
            def deleteHubContent(
                request: DeleteHubContentRequest
            ): IO[AwsError, Unit] = proxy(DeleteHubContent, request)
            def describeNotebookInstance(
                request: DescribeNotebookInstanceRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly
            ] = proxy(DescribeNotebookInstance, request)
            def stopEdgeDeploymentStage(
                request: StopEdgeDeploymentStageRequest
            ): IO[AwsError, Unit] = proxy(StopEdgeDeploymentStage, request)
            def describeModelQualityJobDefinition(
                request: DescribeModelQualityJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly
            ] = proxy(DescribeModelQualityJobDefinition, request)
            def deleteWorkforce(request: DeleteWorkforceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteWorkforceResponse.ReadOnly
            ] = proxy(DeleteWorkforce, request)
            def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
              proxy(DeleteModel, request)
            def listProcessingJobs(request: ListProcessingJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProcessingJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProcessingJobsPaginated(
                request: ListProcessingJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly
            ] = proxy(ListProcessingJobsPaginated, request)
            def deleteExperiment(request: DeleteExperimentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly
            ] = proxy(DeleteExperiment, request)
            def listLineageGroups(request: ListLineageGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLineageGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLineageGroupsPaginated(
                request: ListLineageGroupsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly
            ] = proxy(ListLineageGroupsPaginated, request)
            def deleteArtifact(request: DeleteArtifactRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly
            ] = proxy(DeleteArtifact, request)
            def listSpaces(request: ListSpacesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.SpaceDetails.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSpaces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSpacesPaginated(request: ListSpacesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListSpacesResponse.ReadOnly
            ] = proxy(ListSpacesPaginated, request)
            def deleteWorkteam(request: DeleteWorkteamRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteWorkteamResponse.ReadOnly
            ] = proxy(DeleteWorkteam, request)
            def listEndpointConfigs(
                request: ListEndpointConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEndpointConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEndpointConfigsPaginated(
                request: ListEndpointConfigsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly
            ] = proxy(ListEndpointConfigsPaginated, request)
            def deleteTrialComponent(request: DeleteTrialComponentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly
            ] = proxy(DeleteTrialComponent, request)
            def listAliases(
                request: ListAliasesRequest
            ): ZStream[Any, AwsError, SageMakerImageVersionAlias] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListAliases, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listAliasesPaginated(request: ListAliasesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListAliasesResponse.ReadOnly
            ] = proxy(ListAliasesPaginated, request)
            def sendPipelineExecutionStepSuccess(
                request: SendPipelineExecutionStepSuccessRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly
            ] = proxy(SendPipelineExecutionStepSuccess, request)
            def describeFeatureMetadata(
                request: DescribeFeatureMetadataRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeFeatureMetadataResponse.ReadOnly
            ] = proxy(DescribeFeatureMetadata, request)
            def createInferenceExperiment(
                request: CreateInferenceExperimentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateInferenceExperimentResponse.ReadOnly
            ] = proxy(CreateInferenceExperiment, request)
            def listAutoMLJobs(request: ListAutoMlJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAutoMLJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAutoMLJobsPaginated(request: ListAutoMlJobsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly
            ] = proxy(ListAutoMLJobsPaginated, request)
            def describeModelCard(request: DescribeModelCardRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelCardResponse.ReadOnly
            ] = proxy(DescribeModelCard, request)
            def deleteDeviceFleet(
                request: DeleteDeviceFleetRequest
            ): IO[AwsError, Unit] = proxy(DeleteDeviceFleet, request)
            def listSubscribedWorkteams(
                request: ListSubscribedWorkteamsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscribedWorkteams, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscribedWorkteamsPaginated(
                request: ListSubscribedWorkteamsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListSubscribedWorkteamsResponse.ReadOnly
            ] = proxy(ListSubscribedWorkteamsPaginated, request)
            def updateDevices(
                request: UpdateDevicesRequest
            ): IO[AwsError, Unit] = proxy(UpdateDevices, request)
            def renderUiTemplate(request: RenderUiTemplateRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly
            ] = proxy(RenderUiTemplate, request)
            def createImage(request: CreateImageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateImageResponse.ReadOnly
            ] = proxy(CreateImage, request)
            def describeLabelingJob(request: DescribeLabelingJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly
            ] = proxy(DescribeLabelingJob, request)
            def createHyperParameterTuningJob(
                request: CreateHyperParameterTuningJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateHyperParameterTuningJobResponse.ReadOnly
            ] = proxy(CreateHyperParameterTuningJob, request)
            def createCompilationJob(request: CreateCompilationJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly
            ] = proxy(CreateCompilationJob, request)
            def deleteApp(request: DeleteAppRequest): IO[AwsError, Unit] =
              proxy(DeleteApp, request)
            def describeModelCardExportJob(
                request: DescribeModelCardExportJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelCardExportJobResponse.ReadOnly
            ] = proxy(DescribeModelCardExportJob, request)
            def createWorkforce(request: CreateWorkforceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly
            ] = proxy(CreateWorkforce, request)
            def associateTrialComponent(
                request: AssociateTrialComponentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly
            ] = proxy(AssociateTrialComponent, request)
            def createDomain(request: CreateDomainRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly
            ] = proxy(CreateDomain, request)
            def listArtifacts(request: ListArtifactsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ArtifactSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListArtifacts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listArtifactsPaginated(request: ListArtifactsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly
            ] = proxy(ListArtifactsPaginated, request)
            def listPipelineParametersForExecution(
                request: ListPipelineParametersForExecutionRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.Parameter.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPipelineParametersForExecution, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPipelineParametersForExecutionPaginated(
                request: ListPipelineParametersForExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly
            ] = proxy(ListPipelineParametersForExecutionPaginated, request)
            def disableSagemakerServicecatalogPortfolio(
                request: DisableSagemakerServicecatalogPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse.ReadOnly
            ] = proxy(DisableSagemakerServicecatalogPortfolio, request)
            def createWorkteam(request: CreateWorkteamRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly
            ] = proxy(CreateWorkteam, request)
            def updateCodeRepository(request: UpdateCodeRepositoryRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly
            ] = proxy(UpdateCodeRepository, request)
            def createMonitoringSchedule(
                request: CreateMonitoringScheduleRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly
            ] = proxy(CreateMonitoringSchedule, request)
            def deleteImageVersion(request: DeleteImageVersionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteImageVersionResponse.ReadOnly
            ] = proxy(DeleteImageVersion, request)
            def listTrialComponents(
                request: ListTrialComponentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTrialComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTrialComponentsPaginated(
                request: ListTrialComponentsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly
            ] = proxy(ListTrialComponentsPaginated, request)
            def describeProcessingJob(
                request: DescribeProcessingJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly
            ] = proxy(DescribeProcessingJob, request)
            def listCodeRepositories(
                request: ListCodeRepositoriesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCodeRepositories, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCodeRepositoriesPaginated(
                request: ListCodeRepositoriesRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly
            ] = proxy(ListCodeRepositoriesPaginated, request)
            def listAssociations(request: ListAssociationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.AssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAssociationsPaginated(request: ListAssociationsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly
            ] = proxy(ListAssociationsPaginated, request)
            def listMonitoringAlerts(
                request: ListMonitoringAlertsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMonitoringAlerts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMonitoringAlertsPaginated(
                request: ListMonitoringAlertsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListMonitoringAlertsResponse.ReadOnly
            ] = proxy(ListMonitoringAlertsPaginated, request)
            def describeModelBiasJobDefinition(
                request: DescribeModelBiasJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionResponse.ReadOnly
            ] = proxy(DescribeModelBiasJobDefinition, request)
            def startMonitoringSchedule(
                request: StartMonitoringScheduleRequest
            ): IO[AwsError, Unit] = proxy(StartMonitoringSchedule, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def listTransformJobs(request: ListTransformJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.TransformJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTransformJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTransformJobsPaginated(
                request: ListTransformJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly
            ] = proxy(ListTransformJobsPaginated, request)
            def stopNotebookInstance(
                request: StopNotebookInstanceRequest
            ): IO[AwsError, Unit] = proxy(StopNotebookInstance, request)
            def deleteFlowDefinition(request: DeleteFlowDefinitionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteFlowDefinitionResponse.ReadOnly
            ] = proxy(DeleteFlowDefinition, request)
            def listFeatureGroups(request: ListFeatureGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFeatureGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFeatureGroupsPaginated(
                request: ListFeatureGroupsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly
            ] = proxy(ListFeatureGroupsPaginated, request)
            def describeEndpoint(request: DescribeEndpointRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly
            ] = proxy(DescribeEndpoint, request)
            def updateDomain(request: UpdateDomainRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly
            ] = proxy(UpdateDomain, request)
            def startInferenceExperiment(
                request: StartInferenceExperimentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.StartInferenceExperimentResponse.ReadOnly
            ] = proxy(StartInferenceExperiment, request)
            def listModelExplainabilityJobDefinitions(
                request: ListModelExplainabilityJobDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelExplainabilityJobDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelExplainabilityJobDefinitionsPaginated(
                request: ListModelExplainabilityJobDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse.ReadOnly
            ] = proxy(ListModelExplainabilityJobDefinitionsPaginated, request)
            def createAutoMLJob(request: CreateAutoMlJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateAutoMlJobResponse.ReadOnly
            ] = proxy(CreateAutoMLJob, request)
            def createDeviceFleet(
                request: CreateDeviceFleetRequest
            ): IO[AwsError, Unit] = proxy(CreateDeviceFleet, request)
            def describeAction(request: DescribeActionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly
            ] = proxy(DescribeAction, request)
            def describeApp(request: DescribeAppRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly
            ] = proxy(DescribeApp, request)
            def describeAutoMLJob(request: DescribeAutoMlJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly
            ] = proxy(DescribeAutoMLJob, request)
            def listActions(request: ListActionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ActionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListActions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listActionsPaginated(request: ListActionsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListActionsResponse.ReadOnly
            ] = proxy(ListActionsPaginated, request)
            def updateModelPackage(request: UpdateModelPackageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateModelPackageResponse.ReadOnly
            ] = proxy(UpdateModelPackage, request)
            def describeImage(request: DescribeImageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly
            ] = proxy(DescribeImage, request)
            def deleteContext(request: DeleteContextRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly
            ] = proxy(DeleteContext, request)
            def createInferenceRecommendationsJob(
                request: CreateInferenceRecommendationsJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly
            ] = proxy(CreateInferenceRecommendationsJob, request)
            def createModelPackage(request: CreateModelPackageRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly
            ] = proxy(CreateModelPackage, request)
            def disassociateTrialComponent(
                request: DisassociateTrialComponentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly
            ] = proxy(DisassociateTrialComponent, request)
            def describeSpace(request: DescribeSpaceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeSpaceResponse.ReadOnly
            ] = proxy(DescribeSpace, request)
            def updateFeatureMetadata(
                request: UpdateFeatureMetadataRequest
            ): IO[AwsError, Unit] = proxy(UpdateFeatureMetadata, request)
            def stopTrainingJob(
                request: StopTrainingJobRequest
            ): IO[AwsError, Unit] = proxy(StopTrainingJob, request)
            def createModelBiasJobDefinition(
                request: CreateModelBiasJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly
            ] = proxy(CreateModelBiasJobDefinition, request)
            def deleteNotebookInstance(
                request: DeleteNotebookInstanceRequest
            ): IO[AwsError, Unit] = proxy(DeleteNotebookInstance, request)
            def createFeatureGroup(request: CreateFeatureGroupRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly
            ] = proxy(CreateFeatureGroup, request)
            def describeAppImageConfig(
                request: DescribeAppImageConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly
            ] = proxy(DescribeAppImageConfig, request)
            def listModelCardVersions(
                request: ListModelCardVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelCardVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelCardVersionsPaginated(
                request: ListModelCardVersionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelCardVersionsResponse.ReadOnly
            ] = proxy(ListModelCardVersionsPaginated, request)
            def describeSubscribedWorkteam(
                request: DescribeSubscribedWorkteamRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly
            ] = proxy(DescribeSubscribedWorkteam, request)
            def describeModelPackageGroup(
                request: DescribeModelPackageGroupRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly
            ] = proxy(DescribeModelPackageGroup, request)
            def createPresignedNotebookInstanceUrl(
                request: CreatePresignedNotebookInstanceUrlRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly
            ] = proxy(CreatePresignedNotebookInstanceUrl, request)
            def getSagemakerServicecatalogPortfolioStatus(
                request: GetSagemakerServicecatalogPortfolioStatusRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse.ReadOnly
            ] = proxy(GetSagemakerServicecatalogPortfolioStatus, request)
            def describeInferenceExperiment(
                request: DescribeInferenceExperimentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeInferenceExperimentResponse.ReadOnly
            ] = proxy(DescribeInferenceExperiment, request)
            def listStageDevices(request: ListStageDevicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStageDevices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStageDevicesPaginated(request: ListStageDevicesRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListStageDevicesResponse.ReadOnly
            ] = proxy(ListStageDevicesPaginated, request)
            def deletePipeline(request: DeletePipelineRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly
            ] = proxy(DeletePipeline, request)
            def describePipelineExecution(
                request: DescribePipelineExecutionRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DescribePipelineExecution, request)
            def listFlowDefinitions(
                request: ListFlowDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFlowDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFlowDefinitionsPaginated(
                request: ListFlowDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly
            ] = proxy(ListFlowDefinitionsPaginated, request)
            def importHubContent(request: ImportHubContentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ImportHubContentResponse.ReadOnly
            ] = proxy(ImportHubContent, request)
            def describeProject(request: DescribeProjectRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly
            ] = proxy(DescribeProject, request)
            def listNotebookInstanceLifecycleConfigs(
                request: ListNotebookInstanceLifecycleConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotebookInstanceLifecycleConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotebookInstanceLifecycleConfigsPaginated(
                request: ListNotebookInstanceLifecycleConfigsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly
            ] = proxy(ListNotebookInstanceLifecycleConfigsPaginated, request)
            def updateExperiment(request: UpdateExperimentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly
            ] = proxy(UpdateExperiment, request)
            def listCandidatesForAutoMLJob(
                request: ListCandidatesForAutoMlJobRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCandidatesForAutoMLJob, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCandidatesForAutoMLJobPaginated(
                request: ListCandidatesForAutoMlJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly
            ] = proxy(ListCandidatesForAutoMLJobPaginated, request)
            def deleteModelPackageGroup(
                request: DeleteModelPackageGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteModelPackageGroup, request)
            def listModelPackageGroups(
                request: ListModelPackageGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelPackageGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelPackageGroupsPaginated(
                request: ListModelPackageGroupsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly
            ] = proxy(ListModelPackageGroupsPaginated, request)
            def listHubContentVersions(
                request: ListHubContentVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.HubContentInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHubContentVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHubContentVersionsPaginated(
                request: ListHubContentVersionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListHubContentVersionsResponse.ReadOnly
            ] = proxy(ListHubContentVersionsPaginated, request)
            def createEndpoint(request: CreateEndpointRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly
            ] = proxy(CreateEndpoint, request)
            def deleteDomain(request: DeleteDomainRequest): IO[AwsError, Unit] =
              proxy(DeleteDomain, request)
            def deleteInferenceExperiment(
                request: DeleteInferenceExperimentRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteInferenceExperimentResponse.ReadOnly
            ] = proxy(DeleteInferenceExperiment, request)
            def deleteModelPackageGroupPolicy(
                request: DeleteModelPackageGroupPolicyRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteModelPackageGroupPolicy, request)
            def listMonitoringExecutions(
                request: ListMonitoringExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMonitoringExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMonitoringExecutionsPaginated(
                request: ListMonitoringExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly
            ] = proxy(ListMonitoringExecutionsPaginated, request)
            def deleteModelBiasJobDefinition(
                request: DeleteModelBiasJobDefinitionRequest
            ): IO[AwsError, Unit] = proxy(DeleteModelBiasJobDefinition, request)
            def startEdgeDeploymentStage(
                request: StartEdgeDeploymentStageRequest
            ): IO[AwsError, Unit] = proxy(StartEdgeDeploymentStage, request)
            def describeWorkteam(request: DescribeWorkteamRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeWorkteamResponse.ReadOnly
            ] = proxy(DescribeWorkteam, request)
            def updateEndpoint(request: UpdateEndpointRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly
            ] = proxy(UpdateEndpoint, request)
            def createEdgeDeploymentPlan(
                request: CreateEdgeDeploymentPlanRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse.ReadOnly
            ] = proxy(CreateEdgeDeploymentPlan, request)
            def listTrainingJobsForHyperParameterTuningJob(
                request: ListTrainingJobsForHyperParameterTuningJobRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTrainingJobsForHyperParameterTuningJob, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTrainingJobsForHyperParameterTuningJobPaginated(
                request: ListTrainingJobsForHyperParameterTuningJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse.ReadOnly
            ] = proxy(
              ListTrainingJobsForHyperParameterTuningJobPaginated,
              request
            )
            def listEndpoints(request: ListEndpointsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.EndpointSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEndpoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEndpointsPaginated(request: ListEndpointsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly
            ] = proxy(ListEndpointsPaginated, request)
            def listContexts(request: ListContextsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ContextSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContexts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContextsPaginated(request: ListContextsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListContextsResponse.ReadOnly
            ] = proxy(ListContextsPaginated, request)
            def describeImageVersion(request: DescribeImageVersionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly
            ] = proxy(DescribeImageVersion, request)
            def stopAutoMLJob(
                request: StopAutoMlJobRequest
            ): IO[AwsError, Unit] = proxy(StopAutoMLJob, request)
            def describeMonitoringSchedule(
                request: DescribeMonitoringScheduleRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly
            ] = proxy(DescribeMonitoringSchedule, request)
            def deleteFeatureGroup(
                request: DeleteFeatureGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteFeatureGroup, request)
            def createHumanTaskUi(request: CreateHumanTaskUiRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateHumanTaskUiResponse.ReadOnly
            ] = proxy(CreateHumanTaskUi, request)
            def createAppImageConfig(request: CreateAppImageConfigRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly
            ] = proxy(CreateAppImageConfig, request)
            def describeUserProfile(request: DescribeUserProfileRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly
            ] = proxy(DescribeUserProfile, request)
            def stopHyperParameterTuningJob(
                request: StopHyperParameterTuningJobRequest
            ): IO[AwsError, Unit] = proxy(StopHyperParameterTuningJob, request)
            def search(request: SearchRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.SearchRecord.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(Search, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchPaginated(
                request: SearchRequest
            ): IO[AwsError, zio.aws.sagemaker.model.SearchResponse.ReadOnly] =
              proxy(SearchPaginated, request)
            def listExperiments(request: ListExperimentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.ExperimentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExperiments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExperimentsPaginated(request: ListExperimentsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly
            ] = proxy(ListExperimentsPaginated, request)
            def describeCodeRepository(
                request: DescribeCodeRepositoryRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeCodeRepositoryResponse.ReadOnly
            ] = proxy(DescribeCodeRepository, request)
            def deleteUserProfile(
                request: DeleteUserProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteUserProfile, request)
            def putModelPackageGroupPolicy(
                request: PutModelPackageGroupPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.PutModelPackageGroupPolicyResponse.ReadOnly
            ] = proxy(PutModelPackageGroupPolicy, request)
            def updateSpace(request: UpdateSpaceRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateSpaceResponse.ReadOnly
            ] = proxy(UpdateSpace, request)
            def stopPipelineExecution(
                request: StopPipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.StopPipelineExecutionResponse.ReadOnly
            ] = proxy(StopPipelineExecution, request)
            def listPipelineExecutionSteps(
                request: ListPipelineExecutionStepsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPipelineExecutionSteps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPipelineExecutionStepsPaginated(
                request: ListPipelineExecutionStepsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly
            ] = proxy(ListPipelineExecutionStepsPaginated, request)
            def deleteModelPackage(
                request: DeleteModelPackageRequest
            ): IO[AwsError, Unit] = proxy(DeleteModelPackage, request)
            def describePipelineDefinitionForExecution(
                request: DescribePipelineDefinitionForExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly
            ] = proxy(DescribePipelineDefinitionForExecution, request)
            def deleteNotebookInstanceLifecycleConfig(
                request: DeleteNotebookInstanceLifecycleConfigRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteNotebookInstanceLifecycleConfig, request)
            def listInferenceRecommendationsJobSteps(
                request: ListInferenceRecommendationsJobStepsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceRecommendationsJobSteps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceRecommendationsJobStepsPaginated(
                request: ListInferenceRecommendationsJobStepsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse.ReadOnly
            ] = proxy(ListInferenceRecommendationsJobStepsPaginated, request)
            def deleteCodeRepository(
                request: DeleteCodeRepositoryRequest
            ): IO[AwsError, Unit] = proxy(DeleteCodeRepository, request)
            def listMonitoringAlertHistory(
                request: ListMonitoringAlertHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMonitoringAlertHistory, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMonitoringAlertHistoryPaginated(
                request: ListMonitoringAlertHistoryRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse.ReadOnly
            ] = proxy(ListMonitoringAlertHistoryPaginated, request)
            def describeFeatureGroup(
                request: DescribeFeatureGroupRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly,
              zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
            ]] = proxy(DescribeFeatureGroup, request)
            def describeFeatureGroupPaginated(
                request: DescribeFeatureGroupRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly
            ] = proxy(DescribeFeatureGroupPaginated, request)
            def updateArtifact(request: UpdateArtifactRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly
            ] = proxy(UpdateArtifact, request)
            def describeHub(request: DescribeHubRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeHubResponse.ReadOnly
            ] = proxy(DescribeHub, request)
            def stopProcessingJob(
                request: StopProcessingJobRequest
            ): IO[AwsError, Unit] = proxy(StopProcessingJob, request)
            def deleteSpace(request: DeleteSpaceRequest): IO[AwsError, Unit] =
              proxy(DeleteSpace, request)
            def stopInferenceRecommendationsJob(
                request: StopInferenceRecommendationsJobRequest
            ): IO[AwsError, Unit] =
              proxy(StopInferenceRecommendationsJob, request)
            def deleteProject(
                request: DeleteProjectRequest
            ): IO[AwsError, Unit] = proxy(DeleteProject, request)
            def updateTrial(request: UpdateTrialRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly
            ] = proxy(UpdateTrial, request)
            def createModelCardExportJob(
                request: CreateModelCardExportJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelCardExportJobResponse.ReadOnly
            ] = proxy(CreateModelCardExportJob, request)
            def describeHubContent(request: DescribeHubContentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeHubContentResponse.ReadOnly
            ] = proxy(DescribeHubContent, request)
            def createImageVersion(request: CreateImageVersionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly
            ] = proxy(CreateImageVersion, request)
            def deleteTags(request: DeleteTagsRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DeleteTagsResponse.ReadOnly
            ] = proxy(DeleteTags, request)
            def createPipeline(request: CreatePipelineRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly
            ] = proxy(CreatePipeline, request)
            def describeArtifact(request: DescribeArtifactRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly
            ] = proxy(DescribeArtifact, request)
            def updateImageVersion(request: UpdateImageVersionRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateImageVersionResponse.ReadOnly
            ] = proxy(UpdateImageVersion, request)
            def describeContext(request: DescribeContextRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly
            ] = proxy(DescribeContext, request)
            def describeTrainingJob(request: DescribeTrainingJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly
            ] = proxy(DescribeTrainingJob, request)
            def sendPipelineExecutionStepFailure(
                request: SendPipelineExecutionStepFailureRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly
            ] = proxy(SendPipelineExecutionStepFailure, request)
            def listStudioLifecycleConfigs(
                request: ListStudioLifecycleConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStudioLifecycleConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStudioLifecycleConfigsPaginated(
                request: ListStudioLifecycleConfigsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly
            ] = proxy(ListStudioLifecycleConfigsPaginated, request)
            def updateEndpointWeightsAndCapacities(
                request: UpdateEndpointWeightsAndCapacitiesRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly
            ] = proxy(UpdateEndpointWeightsAndCapacities, request)
            def createNotebookInstanceLifecycleConfig(
                request: CreateNotebookInstanceLifecycleConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly
            ] = proxy(CreateNotebookInstanceLifecycleConfig, request)
            def createAutoMLJobV2(request: CreateAutoMlJobV2Request): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateAutoMlJobV2Response.ReadOnly
            ] = proxy(CreateAutoMLJobV2, request)
            def createEdgePackagingJob(
                request: CreateEdgePackagingJobRequest
            ): IO[AwsError, Unit] = proxy(CreateEdgePackagingJob, request)
            def updateFeatureGroup(request: UpdateFeatureGroupRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.UpdateFeatureGroupResponse.ReadOnly
            ] = proxy(UpdateFeatureGroup, request)
            def describeAutoMLJobV2(request: DescribeAutoMlJobV2Request): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeAutoMlJobV2Response.ReadOnly
            ] = proxy(DescribeAutoMLJobV2, request)
            def createModelCard(request: CreateModelCardRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateModelCardResponse.ReadOnly
            ] = proxy(CreateModelCard, request)
            def describeInferenceRecommendationsJob(
                request: DescribeInferenceRecommendationsJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly
            ] = proxy(DescribeInferenceRecommendationsJob, request)
            def createPresignedDomainUrl(
                request: CreatePresignedDomainUrlRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly
            ] = proxy(CreatePresignedDomainUrl, request)
            def describeModel(request: DescribeModelRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly
            ] = proxy(DescribeModel, request)
            def registerDevices(
                request: RegisterDevicesRequest
            ): IO[AwsError, Unit] = proxy(RegisterDevices, request)
            def describeCompilationJob(
                request: DescribeCompilationJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly
            ] = proxy(DescribeCompilationJob, request)
            def listDataQualityJobDefinitions(
                request: ListDataQualityJobDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataQualityJobDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataQualityJobDefinitionsPaginated(
                request: ListDataQualityJobDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListDataQualityJobDefinitionsResponse.ReadOnly
            ] = proxy(ListDataQualityJobDefinitionsPaginated, request)
            def stopTransformJob(
                request: StopTransformJobRequest
            ): IO[AwsError, Unit] = proxy(StopTransformJob, request)
            def deleteEndpointConfig(
                request: DeleteEndpointConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteEndpointConfig, request)
            def stopCompilationJob(
                request: StopCompilationJobRequest
            ): IO[AwsError, Unit] = proxy(StopCompilationJob, request)
            def describeModelExplainabilityJobDefinition(
                request: DescribeModelExplainabilityJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly
            ] = proxy(DescribeModelExplainabilityJobDefinition, request)
            def describeTransformJob(request: DescribeTransformJobRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly
            ] = proxy(DescribeTransformJob, request)
            def deleteEdgeDeploymentPlan(
                request: DeleteEdgeDeploymentPlanRequest
            ): IO[AwsError, Unit] = proxy(DeleteEdgeDeploymentPlan, request)
            def createUserProfile(request: CreateUserProfileRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly
            ] = proxy(CreateUserProfile, request)
            def createDataQualityJobDefinition(
                request: CreateDataQualityJobDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly
            ] = proxy(CreateDataQualityJobDefinition, request)
            def describeExperiment(request: DescribeExperimentRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly
            ] = proxy(DescribeExperiment, request)
            def listInferenceRecommendationsJobs(
                request: ListInferenceRecommendationsJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceRecommendationsJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceRecommendationsJobsPaginated(
                request: ListInferenceRecommendationsJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly
            ] = proxy(ListInferenceRecommendationsJobsPaginated, request)
            def describeEndpointConfig(
                request: DescribeEndpointConfigRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly
            ] = proxy(DescribeEndpointConfig, request)
            def describeHyperParameterTuningJob(
                request: DescribeHyperParameterTuningJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly
            ] = proxy(DescribeHyperParameterTuningJob, request)
            def createHub(request: CreateHubRequest): IO[
              AwsError,
              zio.aws.sagemaker.model.CreateHubResponse.ReadOnly
            ] = proxy(CreateHub, request)
            def batchDescribeModelPackage(
                request: BatchDescribeModelPackageRequest
            ): IO[
              AwsError,
              zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly
            ] = proxy(BatchDescribeModelPackage, request)
          }
        }
      }
    }
  }
}
