package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.TransformJobArn
import scala.jdk.CollectionConverters._
final case class TransformJobStepMetadata(
    arn: Optional[TransformJobArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformJobStepMetadata = {
    import TransformJobStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformJobStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => TransformJobArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformJobStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.TransformJobStepMetadata.wrap(buildAwsValue())
}
object TransformJobStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformJobStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformJobStepMetadata =
      zio.aws.sagemaker.model.TransformJobStepMetadata(arn.map(value => value))
    def arn: Optional[TransformJobArn]
    def getArn: ZIO[Any, AwsError, TransformJobArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJobStepMetadata
  ) extends zio.aws.sagemaker.model.TransformJobStepMetadata.ReadOnly {
    override val arn: Optional[TransformJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.TransformJobArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJobStepMetadata
  ): zio.aws.sagemaker.model.TransformJobStepMetadata.ReadOnly = new Wrapper(
    impl
  )
}
