package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait TrafficRoutingConfigType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType
}
object TrafficRoutingConfigType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType
  ): zio.aws.sagemaker.model.TrafficRoutingConfigType = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.ALL_AT_ONCE =>
      val r = ALL_AT_ONCE
      r
    case software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.CANARY =>
      val r = CANARY
      r
    case software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.LINEAR =>
      val r = LINEAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrafficRoutingConfigType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType =
      software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_AT_ONCE
      extends zio.aws.sagemaker.model.TrafficRoutingConfigType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType =
      software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.ALL_AT_ONCE
  }
  case object CANARY extends zio.aws.sagemaker.model.TrafficRoutingConfigType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType =
      software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.CANARY
  }
  case object LINEAR extends zio.aws.sagemaker.model.TrafficRoutingConfigType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType =
      software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType.LINEAR
  }
}
