package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AppManaged
import scala.jdk.CollectionConverters._
final case class ProcessingInput(
    inputName: String,
    appManaged: Optional[AppManaged] = Optional.Absent,
    s3Input: Optional[zio.aws.sagemaker.model.ProcessingS3Input] =
      Optional.Absent,
    datasetDefinition: Optional[zio.aws.sagemaker.model.DatasetDefinition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingInput = {
    import ProcessingInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingInput
      .builder()
      .inputName(inputName: java.lang.String)
      .optionallyWith(
        appManaged.map(value => AppManaged.unwrap(value): java.lang.Boolean)
      )(_.appManaged)
      .optionallyWith(s3Input.map(value => value.buildAwsValue()))(_.s3Input)
      .optionallyWith(datasetDefinition.map(value => value.buildAwsValue()))(
        _.datasetDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingInput.ReadOnly =
    zio.aws.sagemaker.model.ProcessingInput.wrap(buildAwsValue())
}
object ProcessingInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingInput =
      zio.aws.sagemaker.model.ProcessingInput(
        inputName,
        appManaged.map(value => value),
        s3Input.map(value => value.asEditable),
        datasetDefinition.map(value => value.asEditable)
      )
    def inputName: String
    def appManaged: Optional[AppManaged]
    def s3Input: Optional[zio.aws.sagemaker.model.ProcessingS3Input.ReadOnly]
    def datasetDefinition
        : Optional[zio.aws.sagemaker.model.DatasetDefinition.ReadOnly]
    def getInputName: ZIO[Any, Nothing, String] = ZIO.succeed(inputName)
    def getAppManaged: ZIO[Any, AwsError, AppManaged] =
      AwsError.unwrapOptionField("appManaged", appManaged)
    def getS3Input: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingS3Input.ReadOnly
    ] = AwsError.unwrapOptionField("s3Input", s3Input)
    def getDatasetDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DatasetDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("datasetDefinition", datasetDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingInput
  ) extends zio.aws.sagemaker.model.ProcessingInput.ReadOnly {
    override val inputName: String = impl.inputName(): String
    override val appManaged: Optional[AppManaged] = zio.aws.core.internal
      .optionalFromNullable(impl.appManaged())
      .map(value => zio.aws.sagemaker.model.primitives.AppManaged(value))
    override val s3Input
        : Optional[zio.aws.sagemaker.model.ProcessingS3Input.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Input())
        .map(value => zio.aws.sagemaker.model.ProcessingS3Input.wrap(value))
    override val datasetDefinition
        : Optional[zio.aws.sagemaker.model.DatasetDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetDefinition())
        .map(value => zio.aws.sagemaker.model.DatasetDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingInput
  ): zio.aws.sagemaker.model.ProcessingInput.ReadOnly = new Wrapper(impl)
}
