package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait PipelineStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.PipelineStatus
}
object PipelineStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.PipelineStatus
  ): zio.aws.sagemaker.model.PipelineStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.PipelineStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.PipelineStatus.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.sagemaker.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineStatus.ACTIVE
  }
}
