package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  ExperimentEntityName,
  Timestamp,
  MaxResults,
  String256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrialComponentsRequest(
    experimentName: Optional[ExperimentEntityName] = Optional.Absent,
    trialName: Optional[ExperimentEntityName] = Optional.Absent,
    sourceArn: Optional[String256] = Optional.Absent,
    createdAfter: Optional[Timestamp] = Optional.Absent,
    createdBefore: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.SortTrialComponentsBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest = {
    import ListTrialComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
      .builder()
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        sourceArn.map(value => String256.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTrialComponentsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListTrialComponentsRequest.wrap(buildAwsValue())
}
object ListTrialComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTrialComponentsRequest =
      zio.aws.sagemaker.model.ListTrialComponentsRequest(
        experimentName.map(value => value),
        trialName.map(value => value),
        sourceArn.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def experimentName: Optional[ExperimentEntityName]
    def trialName: Optional[ExperimentEntityName]
    def sourceArn: Optional[String256]
    def createdAfter: Optional[Timestamp]
    def createdBefore: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.SortTrialComponentsBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getSourceArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SortTrialComponentsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
  ) extends zio.aws.sagemaker.model.ListTrialComponentsRequest.ReadOnly {
    override val experimentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val sourceArn: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val createdAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.SortTrialComponentsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.SortTrialComponentsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest
  ): zio.aws.sagemaker.model.ListTrialComponentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
