package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{ArnOrName, AlgorithmImage}
import scala.jdk.CollectionConverters._
final case class HyperParameterAlgorithmSpecification(
    trainingImage: Optional[AlgorithmImage] = Optional.Absent,
    trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode,
    algorithmName: Optional[ArnOrName] = Optional.Absent,
    metricDefinitions: Optional[
      Iterable[zio.aws.sagemaker.model.MetricDefinition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification = {
    import HyperParameterAlgorithmSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification
      .builder()
      .optionallyWith(
        trainingImage.map(value =>
          AlgorithmImage.unwrap(value): java.lang.String
        )
      )(_.trainingImage)
      .trainingInputMode(trainingInputMode.unwrap)
      .optionallyWith(
        algorithmName.map(value => ArnOrName.unwrap(value): java.lang.String)
      )(_.algorithmName)
      .optionallyWith(
        metricDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDefinitions)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification
      .wrap(buildAwsValue())
}
object HyperParameterAlgorithmSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification =
      zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification(
        trainingImage.map(value => value),
        trainingInputMode,
        algorithmName.map(value => value),
        metricDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trainingImage: Optional[AlgorithmImage]
    def trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode
    def algorithmName: Optional[ArnOrName]
    def metricDefinitions
        : Optional[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]]
    def getTrainingImage: ZIO[Any, AwsError, AlgorithmImage] =
      AwsError.unwrapOptionField("trainingImage", trainingImage)
    def getTrainingInputMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInputMode] =
      ZIO.succeed(trainingInputMode)
    def getAlgorithmName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("algorithmName", algorithmName)
    def getMetricDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDefinitions", metricDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification
  ) extends zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly {
    override val trainingImage: Optional[AlgorithmImage] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingImage())
      .map(value => zio.aws.sagemaker.model.primitives.AlgorithmImage(value))
    override val trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode =
      zio.aws.sagemaker.model.TrainingInputMode.wrap(impl.trainingInputMode())
    override val algorithmName: Optional[ArnOrName] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmName())
      .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val metricDefinitions
        : Optional[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MetricDefinition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification
  ): zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly =
    new Wrapper(impl)
}
