package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoMLResolvedAttributes(
    autoMLJobObjective: Optional[zio.aws.sagemaker.model.AutoMLJobObjective] =
      Optional.Absent,
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    autoMLProblemTypeResolvedAttributes: Optional[
      zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLResolvedAttributes = {
    import AutoMLResolvedAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLResolvedAttributes
      .builder()
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .optionallyWith(
        autoMLProblemTypeResolvedAttributes.map(value => value.buildAwsValue())
      )(_.autoMLProblemTypeResolvedAttributes)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLResolvedAttributes.ReadOnly =
    zio.aws.sagemaker.model.AutoMLResolvedAttributes.wrap(buildAwsValue())
}
object AutoMLResolvedAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLResolvedAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLResolvedAttributes =
      zio.aws.sagemaker.model.AutoMLResolvedAttributes(
        autoMLJobObjective.map(value => value.asEditable),
        completionCriteria.map(value => value.asEditable),
        autoMLProblemTypeResolvedAttributes.map(value => value.asEditable)
      )
    def autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def autoMLProblemTypeResolvedAttributes: Optional[
      zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.ReadOnly
    ]
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getAutoMLProblemTypeResolvedAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoMLProblemTypeResolvedAttributes",
      autoMLProblemTypeResolvedAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLResolvedAttributes
  ) extends zio.aws.sagemaker.model.AutoMLResolvedAttributes.ReadOnly {
    override val autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobObjective())
        .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val autoMLProblemTypeResolvedAttributes: Optional[
      zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoMLProblemTypeResolvedAttributes())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLProblemTypeResolvedAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLResolvedAttributes
  ): zio.aws.sagemaker.model.AutoMLResolvedAttributes.ReadOnly = new Wrapper(
    impl
  )
}
