package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MaxParallelExecutionSteps
import scala.jdk.CollectionConverters._
final case class ParallelismConfiguration(
    maxParallelExecutionSteps: MaxParallelExecutionSteps
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration = {
    import ParallelismConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration
      .builder()
      .maxParallelExecutionSteps(
        MaxParallelExecutionSteps.unwrap(maxParallelExecutionSteps): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly =
    zio.aws.sagemaker.model.ParallelismConfiguration.wrap(buildAwsValue())
}
object ParallelismConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ParallelismConfiguration =
      zio.aws.sagemaker.model
        .ParallelismConfiguration(maxParallelExecutionSteps)
    def maxParallelExecutionSteps: MaxParallelExecutionSteps
    def getMaxParallelExecutionSteps
        : ZIO[Any, Nothing, MaxParallelExecutionSteps] =
      ZIO.succeed(maxParallelExecutionSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration
  ) extends zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly {
    override val maxParallelExecutionSteps: MaxParallelExecutionSteps =
      zio.aws.sagemaker.model.primitives
        .MaxParallelExecutionSteps(impl.maxParallelExecutionSteps())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration
  ): zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
