package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait DeviceSubsetType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType
}
object DeviceSubsetType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType
  ): zio.aws.sagemaker.model.DeviceSubsetType = value match {
    case software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.PERCENTAGE =>
      val r = PERCENTAGE
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.SELECTION =>
      val r = SELECTION
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.NAMECONTAINS =>
      val r = NAMECONTAINS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.DeviceSubsetType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType =
      software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERCENTAGE extends zio.aws.sagemaker.model.DeviceSubsetType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType =
      software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.PERCENTAGE
  }
  case object SELECTION extends zio.aws.sagemaker.model.DeviceSubsetType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType =
      software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.SELECTION
  }
  case object NAMECONTAINS extends zio.aws.sagemaker.model.DeviceSubsetType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType =
      software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType.NAMECONTAINS
  }
}
