package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DeleteEdgeDeploymentStageRequest(
    edgeDeploymentPlanName: EntityName,
    stageName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest = {
    import DeleteEdgeDeploymentStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest
      .builder()
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .stageName(EntityName.unwrap(stageName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteEdgeDeploymentStageRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteEdgeDeploymentStageRequest
      .wrap(buildAwsValue())
}
object DeleteEdgeDeploymentStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteEdgeDeploymentStageRequest =
      zio.aws.sagemaker.model
        .DeleteEdgeDeploymentStageRequest(edgeDeploymentPlanName, stageName)
    def edgeDeploymentPlanName: EntityName
    def stageName: EntityName
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getStageName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest
  ) extends zio.aws.sagemaker.model.DeleteEdgeDeploymentStageRequest.ReadOnly {
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val stageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.stageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest
  ): zio.aws.sagemaker.model.DeleteEdgeDeploymentStageRequest.ReadOnly =
    new Wrapper(impl)
}
