package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.UserProfileArn
import scala.jdk.CollectionConverters._
final case class UpdateUserProfileResponse(
    userProfileArn: Optional[UserProfileArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse = {
    import UpdateUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse
      .builder()
      .optionallyWith(
        userProfileArn.map(value =>
          UserProfileArn.unwrap(value): java.lang.String
        )
      )(_.userProfileArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateUserProfileResponse.wrap(buildAwsValue())
}
object UpdateUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateUserProfileResponse =
      zio.aws.sagemaker.model
        .UpdateUserProfileResponse(userProfileArn.map(value => value))
    def userProfileArn: Optional[UserProfileArn]
    def getUserProfileArn: ZIO[Any, AwsError, UserProfileArn] =
      AwsError.unwrapOptionField("userProfileArn", userProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse
  ) extends zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly {
    override val userProfileArn: Optional[UserProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileArn())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse
  ): zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
