package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  TrialComponentArn,
  ExperimentEntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TrialComponentSummary(
    trialComponentName: Optional[ExperimentEntityName] = Optional.Absent,
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    trialComponentSource: Optional[
      zio.aws.sagemaker.model.TrialComponentSource
    ] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.TrialComponentStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary = {
    import TrialComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
      .builder()
      .optionallyWith(
        trialComponentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialComponentName)
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(trialComponentSource.map(value => value.buildAwsValue()))(
        _.trialComponentSource
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentSummary.wrap(buildAwsValue())
}
object TrialComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentSummary =
      zio.aws.sagemaker.model.TrialComponentSummary(
        trialComponentName.map(value => value),
        trialComponentArn.map(value => value),
        displayName.map(value => value),
        trialComponentSource.map(value => value.asEditable),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def trialComponentName: Optional[ExperimentEntityName]
    def trialComponentArn: Optional[TrialComponentArn]
    def displayName: Optional[ExperimentEntityName]
    def trialComponentSource
        : Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly]
    def status: Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getTrialComponentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialComponentName", trialComponentName)
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTrialComponentSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSource.ReadOnly
    ] = AwsError.unwrapOptionField("trialComponentSource", trialComponentSource)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
  ) extends zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly {
    override val trialComponentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialComponentSource
        : Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentSource())
        .map(value => zio.aws.sagemaker.model.TrialComponentSource.wrap(value))
    override val status
        : Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
  ): zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly = new Wrapper(impl)
}
