package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, EndpointArn, EndpointName}
import scala.jdk.CollectionConverters._
final case class ModelDashboardEndpoint(
    endpointName: EndpointName,
    endpointArn: EndpointArn,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    endpointStatus: zio.aws.sagemaker.model.EndpointStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint = {
    import ModelDashboardEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .endpointArn(EndpointArn.unwrap(endpointArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .endpointStatus(endpointStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDashboardEndpoint.ReadOnly =
    zio.aws.sagemaker.model.ModelDashboardEndpoint.wrap(buildAwsValue())
}
object ModelDashboardEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDashboardEndpoint =
      zio.aws.sagemaker.model.ModelDashboardEndpoint(
        endpointName,
        endpointArn,
        creationTime,
        lastModifiedTime,
        endpointStatus
      )
    def endpointName: EndpointName
    def endpointArn: EndpointArn
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def endpointStatus: zio.aws.sagemaker.model.EndpointStatus
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getEndpointArn: ZIO[Any, Nothing, EndpointArn] =
      ZIO.succeed(endpointArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getEndpointStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointStatus] =
      ZIO.succeed(endpointStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint
  ) extends zio.aws.sagemaker.model.ModelDashboardEndpoint.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val endpointArn: EndpointArn =
      zio.aws.sagemaker.model.primitives.EndpointArn(impl.endpointArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val endpointStatus: zio.aws.sagemaker.model.EndpointStatus =
      zio.aws.sagemaker.model.EndpointStatus.wrap(impl.endpointStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint
  ): zio.aws.sagemaker.model.ModelDashboardEndpoint.ReadOnly = new Wrapper(impl)
}
