package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, WorkteamName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSubscribedWorkteamsRequest(
    nameContains: Optional[WorkteamName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest = {
    import ListSubscribedWorkteamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
      .builder()
      .optionallyWith(
        nameContains.map(value => WorkteamName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.wrap(buildAwsValue())
}
object ListSubscribedWorkteamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest =
      zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest(
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nameContains: Optional[WorkteamName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNameContains: ZIO[Any, AwsError, WorkteamName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
  ) extends zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.ReadOnly {
    override val nameContains: Optional[WorkteamName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.WorkteamName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
  ): zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.ReadOnly =
    new Wrapper(impl)
}
