package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IamIdentity(
    arn: Optional[String] = Optional.Absent,
    principalId: Optional[String] = Optional.Absent,
    sourceIdentity: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.IamIdentity = {
    import IamIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.IamIdentity
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(sourceIdentity.map(value => value: java.lang.String))(
        _.sourceIdentity
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.IamIdentity.ReadOnly =
    zio.aws.sagemaker.model.IamIdentity.wrap(buildAwsValue())
}
object IamIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.IamIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.IamIdentity =
      zio.aws.sagemaker.model.IamIdentity(
        arn.map(value => value),
        principalId.map(value => value),
        sourceIdentity.map(value => value)
      )
    def arn: Optional[String]
    def principalId: Optional[String]
    def sourceIdentity: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getSourceIdentity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentity", sourceIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.IamIdentity
  ) extends zio.aws.sagemaker.model.IamIdentity.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val principalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: String)
    override val sourceIdentity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdentity())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.IamIdentity
  ): zio.aws.sagemaker.model.IamIdentity.ReadOnly = new Wrapper(impl)
}
