package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ClarifyEnableExplanations
import scala.jdk.CollectionConverters._
final case class ClarifyExplainerConfig(
    enableExplanations: Optional[ClarifyEnableExplanations] = Optional.Absent,
    inferenceConfig: Optional[zio.aws.sagemaker.model.ClarifyInferenceConfig] =
      Optional.Absent,
    shapConfig: zio.aws.sagemaker.model.ClarifyShapConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ClarifyExplainerConfig = {
    import ClarifyExplainerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ClarifyExplainerConfig
      .builder()
      .optionallyWith(
        enableExplanations.map(value =>
          ClarifyEnableExplanations.unwrap(value): java.lang.String
        )
      )(_.enableExplanations)
      .optionallyWith(inferenceConfig.map(value => value.buildAwsValue()))(
        _.inferenceConfig
      )
      .shapConfig(shapConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ClarifyExplainerConfig.ReadOnly =
    zio.aws.sagemaker.model.ClarifyExplainerConfig.wrap(buildAwsValue())
}
object ClarifyExplainerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ClarifyExplainerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ClarifyExplainerConfig =
      zio.aws.sagemaker.model.ClarifyExplainerConfig(
        enableExplanations.map(value => value),
        inferenceConfig.map(value => value.asEditable),
        shapConfig.asEditable
      )
    def enableExplanations: Optional[ClarifyEnableExplanations]
    def inferenceConfig
        : Optional[zio.aws.sagemaker.model.ClarifyInferenceConfig.ReadOnly]
    def shapConfig: zio.aws.sagemaker.model.ClarifyShapConfig.ReadOnly
    def getEnableExplanations: ZIO[Any, AwsError, ClarifyEnableExplanations] =
      AwsError.unwrapOptionField("enableExplanations", enableExplanations)
    def getInferenceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ClarifyInferenceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inferenceConfig", inferenceConfig)
    def getShapConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ClarifyShapConfig.ReadOnly
    ] = ZIO.succeed(shapConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyExplainerConfig
  ) extends zio.aws.sagemaker.model.ClarifyExplainerConfig.ReadOnly {
    override val enableExplanations: Optional[ClarifyEnableExplanations] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableExplanations())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyEnableExplanations(value)
        )
    override val inferenceConfig
        : Optional[zio.aws.sagemaker.model.ClarifyInferenceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceConfig())
        .map(value =>
          zio.aws.sagemaker.model.ClarifyInferenceConfig.wrap(value)
        )
    override val shapConfig
        : zio.aws.sagemaker.model.ClarifyShapConfig.ReadOnly =
      zio.aws.sagemaker.model.ClarifyShapConfig.wrap(impl.shapConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyExplainerConfig
  ): zio.aws.sagemaker.model.ClarifyExplainerConfig.ReadOnly = new Wrapper(impl)
}
