package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AutoMLJobObjective(
    metricName: zio.aws.sagemaker.model.AutoMLMetricEnum
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective = {
    import AutoMLJobObjective.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective
      .builder()
      .metricName(metricName.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobObjective.wrap(buildAwsValue())
}
object AutoMLJobObjective {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobObjective =
      zio.aws.sagemaker.model.AutoMLJobObjective(metricName)
    def metricName: zio.aws.sagemaker.model.AutoMLMetricEnum
    def getMetricName
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLMetricEnum] =
      ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective
  ) extends zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly {
    override val metricName: zio.aws.sagemaker.model.AutoMLMetricEnum =
      zio.aws.sagemaker.model.AutoMLMetricEnum.wrap(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective
  ): zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly = new Wrapper(impl)
}
