package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoMLJobConfig(
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    securityConfig: Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig] =
      Optional.Absent,
    dataSplitConfig: Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig] =
      Optional.Absent,
    candidateGenerationConfig: Optional[
      zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig
    ] = Optional.Absent,
    mode: Optional[zio.aws.sagemaker.model.AutoMLMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig = {
    import AutoMLJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
      .builder()
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .optionallyWith(dataSplitConfig.map(value => value.buildAwsValue()))(
        _.dataSplitConfig
      )
      .optionallyWith(
        candidateGenerationConfig.map(value => value.buildAwsValue())
      )(_.candidateGenerationConfig)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobConfig.wrap(buildAwsValue())
}
object AutoMLJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobConfig =
      zio.aws.sagemaker.model.AutoMLJobConfig(
        completionCriteria.map(value => value.asEditable),
        securityConfig.map(value => value.asEditable),
        dataSplitConfig.map(value => value.asEditable),
        candidateGenerationConfig.map(value => value.asEditable),
        mode.map(value => value)
      )
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def securityConfig
        : Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly]
    def dataSplitConfig
        : Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly]
    def candidateGenerationConfig: Optional[
      zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly
    ]
    def mode: Optional[zio.aws.sagemaker.model.AutoMLMode]
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getDataSplitConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataSplitConfig", dataSplitConfig)
    def getCandidateGenerationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "candidateGenerationConfig",
      candidateGenerationConfig
    )
    def getMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLMode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
  ) extends zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly {
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLSecurityConfig.wrap(value))
    override val dataSplitConfig
        : Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSplitConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLDataSplitConfig.wrap(value))
    override val candidateGenerationConfig: Optional[
      zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.candidateGenerationConfig())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.wrap(value)
      )
    override val mode: Optional[zio.aws.sagemaker.model.AutoMLMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.sagemaker.model.AutoMLMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
  ): zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly = new Wrapper(impl)
}
